#ifndef __SETUP_PROTO_INTERNAL_H
#define __SETUP_PROTO_INTERNAL_H

#if !defined(PP_CYGWIN)
#include <netinet/if_ether.h>
#else
#include <sys/socket.h>
#endif

#include <pp/setup_proto.h>

#define PP_SP_MAGIC	0x45524c41
#define PP_SP_VERSION	1
#define PP_SP_CLI_PORT	25832
#define PP_SP_SRV_PORT	25833

typedef struct {
    u_int32_t magic;			/* protocol magic: 0x45524c41 (ERLA) */
    u_int8_t  version;			/* the version of the protocol */
    u_int8_t  dev_id[DEVICE_ID_LEN];	/* the device id (the device MAC address) */
    u_int8_t  command;			/* command */
    u_int32_t id;			/* request id */
} setup_req_hdr_t;

typedef struct {
    u_int32_t magic;			/* protocol magic: 0x45524c41 (ERLA) */
    u_int8_t  version;			/* the version of the protocol */
    u_int8_t  dev_id[DEVICE_ID_LEN];	/* the device id (the device MAC address) */
    u_int8_t  response_code;		/* the response code */
    u_int32_t id;			/* response id */
} setup_rsp_hdr_t;

void _pp_setup_proto_register_errnos(void);
void _pp_setup_proto_unregister_errnos(void);

#endif /* __SETUP_PROTO_INTERNAL_H */
