#ifndef _PP_SMTP_H
#define _PP_SMTP_H

#include <pp/base.h>
#include <pp/vector.h>

typedef struct mail_data_t {
    const char * mail_txt;
    const char * subject;    
    const char * to;
    const char * host;
    const char * from;
    vector_t * extra_hdrs;  /* additional headers (mail_header_t *) */
    time_t time_stamp;  
} mail_data_t;

typedef struct mail_header_t {
    char *name;
    char *val;
} mail_header_t;

int pp_smtp_send_mail(mail_data_t * data);

#endif /* _PP_SMTP_H */
