#include <cppunit/BriefTestProgressListener.h>
#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestResultCollector.h>
#include <cppunit/TestRunner.h>

// fw includes
#include <liberic_config.h>
#include <pp/cfg.h>

// FIXME: is there really no init / cleanup hook for a complete testset?!
static void initialize_runner(void) {
    pp_base_init("raasip_test", LOG_NOT_SILENT);
    eric_config_init(FLUSH_IN_BACKGROUND);
    pp_cfg_init(PP_CD_FNAME_DEFAULT, PP_CD_OEM_SKEL_FNAME_DEFAULT);
}

static void cleanup_runner(void) {
// FIXME: initialization of um lib is part of test... check that somehow!
//    pp_um_cleanup();
    pp_cfg_cleanup();
    eric_config_cleanup();
    pp_base_cleanup();
}

int
main( int, char** )
{
  // Create the event manager and test controller
  CPPUNIT_NS::TestResult controller;

  // Add a listener that colllects test result
  CPPUNIT_NS::TestResultCollector result;
  controller.addListener( &result );

  // Add a listener that print dots as test run.
  CPPUNIT_NS::BriefTestProgressListener progress;
  controller.addListener( &progress );

  initialize_runner();
  
  // Add the top suite to the test runner
  CPPUNIT_NS::TestRunner runner;
  runner.addTest( CPPUNIT_NS::TestFactoryRegistry::getRegistry().makeTest() );
  runner.run( controller );
  
  cleanup_runner();

  // Print test in a compiler compatible format.
  CPPUNIT_NS::CompilerOutputter outputter( &result, std::cerr );
  outputter.write();

  return result.wasSuccessful() ? 0 : 1;
}


