/*
 * standalone um lib test
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <liberic_config.h>
#include <pp/cfg.h>
#include <pp/um.h>

static void print_principals() {
    unsigned int i;
    vector_t* ps = pp_um_UserManager_get_all_principals(PRINCIPAL_TYPE_GROUP |
			PRINCIPAL_TYPE_USER |PRINCIPAL_TYPE_INTERNAL);
    for (i = 0; i < vector_size(ps); ++i) {
	printf("%u: %s\n", i, (char*)vector_get(ps, i));
    }
}
    

int main (int argc, char** argv) {
    int c;
    int deepclean = 0, add = 0, remove = 0, noops = 0;
    char *add_user, *remove_user;

    while (-1 != (c = getopt(argc, argv, "ca:d:"))) {
	switch (c) {
	  case 'c':
	      deepclean = 1;
	      break;
	  case 'a':
	      add = 1;
	      add_user = optarg;
	      noops++;
	      break;
	  case 'd':
	      remove = 1;
	      remove_user = optarg;
	      noops++;
	      break;
	  case '?':
	      exit(1);
	      break;
	  default:
	      printf ("?? getopt returned character code 0%o ??\n", c);
	      exit(1);
	}
    }

    if (deepclean) {
        pp_cfg_destroy();
        return 0;
    }

    eric_config_init(FLUSH_IN_BACKGROUND);
    if (PP_ERR == pp_cfg_init("../../../libpp_cfg/src/test/base.cdl", NULL)) 
	    abort();
    if (PP_ERR == pp_um_init()) {
	    pp_log_err("pp_um_init failed\n");
	    abort();
    }

    print_principals();

    printf("executing %d operations... \n", noops);
 
    if (add) {
	printf("adding user %s ... \n", add_user);
	if (PP_ERR == pp_um_UserManager_create_principal(add_user, "super", 0))
		pp_log_err("pp_um_UserManager_create_principal failed");
	if (PP_ERR == pp_um_UserManager_save_principal(add_user, DO_FLUSH))
		pp_log_err("pp_um_UserManager_save_principal failed");
    }

    if (remove) {
	printf("removing user %s ... \n", remove_user);
	if(PP_ERR == pp_um_UserManager_delete_principal(remove_user))
		pp_log_err("pp_um_UserManager_delete_principal failed");
    }

    print_principals();
    
    pp_um_cleanup();
    pp_cfg_cleanup();
    return 0;
}
