#ifndef _PP_USB_INTERNAL_H
#define _PP_USB_INTERNAL_H

#include <kernel_usb.h>

/* TODO(miba) use this also for the PPC */
#ifdef PP_BOARD_KIRA
# define MSP_USE_ADAPTER
#endif

#ifdef MSP_USE_ADAPTER
# include <msp_adapter.h>
#endif

typedef struct {
    u_int8_t msp_disc_ro;
    u_int8_t msp_disc_type;
    u_int32_t msp_last_sectorno;
    u_int16_t msp_sector_size;
} msp_data_t;

#define MSP_ADAPTER_FRONTEND_FILE_BASE	"/dev/msp_fe"
#define MSP_ADAPTER_BACKEND_FILE	"/dev/msp_be"

extern msp_data_t msp_data[PP_FEAT_USB_MASS_STORAGE_NO];

/* msp.c */
int usb_msp_init(void);
void usb_msp_cleanup(void);
void usb_msp_disconnect(u_int ms_index);
usb_device_type_t usb_msp_get_image_type(u_int ms_index);
int usb_msp_setup_file_info(u_int ms_index);
int usb_msp_cleanup_file_info(u_int ms_index);

#ifdef MSP_USE_ADAPTER
void msp_request_data(u_int ms_index, pp_msp_file_request_t *request, pp_msp_file_response_t *file_response);
void msp_save_write_data(u_int ms_index, pp_msp_file_request_t *request, pp_msp_file_response_t *file_response);
void msp_do_write_data(u_int ms_index, pp_msp_file_request_t *request);
#else /* !MSP_USE_ADAPTER */
void usb_msp_request_data(u_int ms_index, file_request_t *request, file_response_t *file_response);
void usb_msp_save_write_data(u_int ms_index, file_request_t *request, file_response_t *file_response);
void usb_msp_do_write_data(u_int ms_index, file_request_t *request);
#endif /* !MSP_USE_ADAPTER */

const char* usb_msp_get_connected_ip(u_int ms_index);
const char * usb_msp_get_disc_type(u_int ms_index);

/* usb.c */
int usb_ms_set_msp(u_int ms_index, int *error, int initial);

#endif /* _PP_USB_INTERNAL_H */
