#ifndef _ADC_H
#define _ADC_H

#include "context.h"

#if !defined(PP_FEAT_VSC_PANEL_INPUT)

/**************************************************************
 * ADC registers
 **************************************************************/

#define ADC_REG_CHIPREV			0x00
#define ADC_REG_PLL_DIV_MSB		0x01
#define ADC_REG_PLL_DIV_LSB		0x02
#define ADC_REG_VCO_CPMP		0x03
#define ADC_REG_PHASE			0x04
#define ADC_REG_CLAMP_PLACEMENT		0x05
#define ADC_REG_CLAMP_DURATION		0x06
#define ADC_REG_HSYNC_O_PULSE		0x07
#define ADC_REG_RED_GAIN		0x08
#define ADC_REG_GREEN_GAIN		0x09
#define ADC_REG_BLUE_GAIN		0x0A
#define ADC_REG_RED_OFFSET		0x0B
#define ADC_REG_GREEN_OFFSET		0x0C
#define ADC_REG_BLUE_OFFSET		0x0D
#define ADC_REG_SYNC_CONTROL		0x0E
#define	ADC_REG_CLAMP_CONTROL		0x0F
#define ADC_REG_SOG_TRESHOLD		0x10
#define ADC_REG_SS_TRESHOLD		0x11
#define ADC_REG_PRE_COAST		0x12
#define ADC_REG_POST_COAST		0x13
#define ADC_REG_SYNC_DETECT		0x14
#define ADC_REG_GENERAL_MODE		0x15
#define ADC_REG_TEST_1			0x16
#define ADC_REG_TEST_2			0x17
#define ADC_REG_TEST_3			0x18
#define ADC_REG_TEST_4			0x19

/**************************************************************
 * ADC register contents
 **************************************************************/

#define ADC_SYNC_CONTROL_ACT_VSYNC_SSV		0x01
#define ADC_SYNC_CONTROL_ACT_VSYNC_SET		0x02
#define ADC_SYNC_CONTROL_VSYNCO_POL_INV		0x04
#define ADC_SYNC_CONTROL_ACT_HSYNC_SOG		0x08
#define ADC_SYNC_CONTROL_ACT_HSYNC_SET		0x10
#define ADC_SYNC_CONTROL_HSYNCO_POL_LOW		0x20
#define ADC_SYNC_CONTROL_HSYNCI_POL_HIGH	0x40
#define ADC_SYNC_CONTROL_HSYNCI_POL_SET		0x80

#define ADC_CLAMP_CONTROL_STOP_PWRDOWN		0x02
#define ADC_CLAMP_CONTROL_ALLOW_PWRDOWN		0x04
#define ADC_CLAMP_CONTROL_EXT_COAST_HIGH	0x08
#define ADC_CLAMP_CONTROL_COAST_POL_MAN		0x10
#define ADC_CLAMP_CONTROL_COAST_VSYNC		0x20
#define ADC_CLAMP_CONTROL_CLAMP_HIGH		0x40
#define ADC_CLAMP_CONTROL_EXT_CLAMP		0x80

#define ADC_GENERAL_MODE_PLL_OFF		0x01
#define ADC_GENERAL_MODE_BW_75MHZ		(0x0<<1)
#define ADC_GENERAL_MODE_BW_150MHZ		(0x1<<1)
#define ADC_GENERAL_MODE_BW_300MHZ		(0x2<<1)
#define ADC_GENERAL_MODE_BW_500MHZ		(0x3<<1)
#define ADC_GENERAL_MODE_INP_CHANNEL1		0x08
#define ADC_GENERAL_MODE_FORMAT_422		0x10
#define ADC_GENERAL_MODE_PORTB_FIRST		0x20
#define ADC_GENERAL_MODE_PARALLEL		0x40
#define ADC_GENERAL_MODE_DUAL_CHANNEL		0x80

#define ADC_SYNC_DETECT_IN_COAST_POLARITY	0x01
#define ADC_SYNC_DETECT_SOG			0x02
#define ADC_SYNC_DETECT_VSYNC_OUT_POLARITY	0x04
#define ADC_SYNC_DETECT_ACTIVE_VSYNC		0x08
#define ADC_SYNC_DETECT_VSYNC_DETECT		0x10
#define ADC_SYNC_DETECT_IN_HSYNC_DETECT		0x20
#define ADC_SYNC_DETECT_ACTIVE_HSYNC		0x40
#define ADC_SYNC_DETECT_HSYNC_DETECT		0x80

/**************************************************************
 * ADC default values
 **************************************************************/

#define ADC_TEST_1_DEFAULT			0xFE
#define ADC_TEST_2_DEFAULT			0x00

#define ADC_CLAMP_DURATION_DEFAULT		20
#define ADC_HSYNC_O_PULSE_VALUE			0x20

/**************************************************************
 * Functions
 **************************************************************/

int  adc_init(vsc_context_t *context);
void adc_set_bandwidth(vsc_context_t *context, u_int8_t bandwidth);
void adc_set_clamp(vsc_context_t *context, u_int8_t placement,
		   u_int8_t duration);
void adc_sync_mode(vsc_context_t *context, adc_sync_mode_t mode);
pp_bool_t adc_hsync_on(vsc_context_t *context);
pp_bool_t adc_vsync_on(vsc_context_t *context);
int adc_set_pll(vsc_context_t *context, u_int16_t freqH, u_int16_t clocks);
void adc_set_coast_env(vsc_context_t *context, pp_bool_t activate_coast,
		       unsigned char pre, unsigned char post);

/* set/get functions for settings struct with common interface */
int adc_set_brightness(vsc_context_t *context, unsigned short brightness);
int adc_set_brightness_r(vsc_context_t *context, unsigned short brightness);
int adc_set_brightness_g(vsc_context_t *context, unsigned short brightness);
int adc_set_brightness_b(vsc_context_t *context, unsigned short brightness);
int adc_set_contrast_r(vsc_context_t *context, unsigned short contrast);
int adc_set_contrast_g(vsc_context_t *context, unsigned short contrast);
int adc_set_contrast_b(vsc_context_t *context, unsigned short contrast);
int adc_set_blacklevel(vsc_context_t *context, unsigned short blacklevel);
int adc_set_clocks(vsc_context_t *context, unsigned short clocks);
int adc_set_phase(vsc_context_t *context, unsigned short phase);

unsigned short adc_get_brightness(vsc_context_t *context);
unsigned short adc_get_brightness_r(vsc_context_t *context);
unsigned short adc_get_brightness_g(vsc_context_t *context);
unsigned short adc_get_brightness_b(vsc_context_t *context);
unsigned short adc_get_contrast_r(vsc_context_t *context);
unsigned short adc_get_contrast_g(vsc_context_t *context);
unsigned short adc_get_contrast_b(vsc_context_t *context);
unsigned short adc_get_blacklevel(vsc_context_t *context);
unsigned short adc_get_clocks(vsc_context_t *context);
unsigned short adc_get_phase(vsc_context_t *context);

void adc_set_sync_input(vsc_context_t *context);

#endif /* !PP_FEAT_VSC_PANEL_INPUT */

#endif /* _ADC_H */
