#ifndef _ADC_IO_H
#define _ADC_IO_H

#include <sys/types.h>
#include "context.h"

int       adc_io_init(void);
void      adc_io_cleanup(void);

u_int8_t  adc_rx_byte(vsc_context_t *context, u_int8_t reg);
u_int16_t adc_rx_word(vsc_context_t *context, u_int8_t reg);
void	  adc_tx_byte(vsc_context_t *context, u_int8_t reg, u_int8_t data);
void	  adc_tx_word(vsc_context_t *context, u_int8_t reg, u_int16_t data);

void adc_tx_byte_masked(vsc_context_t *context, u_int8_t reg, u_int8_t mask, u_int8_t data);
#endif /* _ADC_IO_H */
