#ifndef _VSC_CONTEXT_H
#define _VSC_CONTEXT_H

/*********************************************************************
 * libpp_vsc: context.h
 *
 * This file contains context (channel/controller) specific data
 *
 * The context-thingy is legacy, we most probably won't have a KIM
 * based device where 1 CPU works with more than 1 video/input path,
 * so this may vanish at some time.
 ********************************************************************/

#include <sys/time.h>
#include <pp/base.h>
#include <liberic_pthread.h>
#include "vsc_types.h"

struct _vsc_context_s {
    unsigned char	id;			// our VSC number
    vsc_features_t	feats;			// feature set depending on version register
    int			fd;			// filedescriptor (channel) we are working on
    unsigned char	adc_i2c_addr;		// I2C address of the ADC
    int			adc_i2c_mux_channel;	// I2C channel behind i2c-mux
    unsigned char	adc_i2c_mux_addr;	// i2c-mux address 0x0 if not needed
    pp_bool_t		vsc_active;		// is VSC programmed and accessible
    pthread_t		thread;			// thread for this context
    char		thread_run;		// thread is running, used for cleanup
   
    u_int16_t		newFreqH;		// measured horizontal frequency, 10 Hz
    u_int16_t		newFreqV;		// measured vertical frequency in 0.1 Hz
    u_int8_t		newPolH;		// horizontal Polarity (1 = +)
    u_int8_t		newPolV;		// vertical Polarity (1 = +)
    u_int8_t		sync_delta_h;		// current horizontal sync delta
    u_int8_t		sync_delta_v;		// current vertical sync delta

    pp_bool_t		ignore_irq;		// ignore IRQ, clear irq reg but don't change state
    pp_bool_t		force_irq;		// virtual IRQ, force reload settings etc.
    pp_bool_t		force_mode_setup;	// setup mode again
    
    aa_data_t		aa_data;		// internal data for auto adjustment
    pp_bool_t		auto_aa;		// automatic adjustment running/allowed?
    vsc_reset_request_t reset_request;		// reset of vsc requested (soft or hard/fpga)
    unsigned char	resume_reset;		// count how often we suspended grabber with reset request
    
    adc_sync_mode_t	adc_sync_mode;		// current adc sync (/separation) mode
    sync_state_t	sync_state;		// current global sync state
    sync_signals_t	input_sync_signals;	// currently available sync signals _before_ the ADC
    sync_signals_t	sync_signals;		// currently available sync signals on VSC, _after_ ADC
    pp_hash_i_t		*current_mode_hash;	// currently active kvm port specific mode hash
    vsc_mode_t		*current_mode;		// pointer to the current video mode
    vsc_mode_t		*nearest_mode;		// pointer to the nearest mode when unknown
    vsc_mode_t		*last_mode;		// pointer to the last video mode        
    pp_bool_t		mode_valid;		// used initially until the first mode is valid
    pp_bool_t		sun_mode;		// workaround for buffer error and larger threshold
    
    pthread_mutex_t	kvm_port_mtx;		// lock kvm port change
    unsigned char	kvm_unit;		// kvm unit we are working on
    unsigned short	kvm_port;		// kvm port we are working on
    pp_bool_t		kvm_port_changed;	// flag if kvm port has change (propchange)    
   
    timer_entry_t	timers[MAX_TIMER_COUNT];// independend timer counters/flags
    suseconds_t		timer_tick_ms;		// duration of a timer tick, time we sleep
    suseconds_t		timer_tick_fast_ms;	// same, but small one for fast operations (aa)
    struct timeval	timer_last;		// last timer run, used to calc difference

    unsigned char       local_video_state;      // cache local video state to set it after vsc reset again

    struct		ddc_data_s *ddc_data;	// data for ddc handling, edid etc.
};

extern vsc_context_t  *vsc_contexts;


#endif /* _VSC_CONTEXT_H */
