#ifndef _PP_VSC_TYPES_EXTERNAL_H
#define _PP_VSC_TYPES_EXTERNAL_H

/* -------------------- vsc video settings --------------------------- */
#define	VIDEO_SETTING_BRIGHTNESS	0
#define VIDEO_SETTING_CONTRAST_R	1
#define VIDEO_SETTING_CONTRAST_G	2
#define VIDEO_SETTING_CONTRAST_B	3
#define VIDEO_SETTING_CLOCK		4
#define VIDEO_SETTING_PHASE		5
#define VIDEO_SETTING_OFFSET_X		6
#define VIDEO_SETTING_OFFSET_Y	        7

#define VIDEO_SETTING_RESET_ALL		8
#define VIDEO_SETTING_RESET_CURRENT	9
#define VIDEO_SETTING_SAVE_SETTINGS	10
#define VIDEO_SETTING_CANCEL_SETTINGS	11
#define VIDEO_SETTING_AUTO_ADJUST	12

typedef struct {
    unsigned char  brightness;
    unsigned char  contrast_red;
    unsigned char  contrast_green;
    unsigned char  contrast_blue;
    unsigned short clock;
    unsigned short phase;
    unsigned short offset_x;
    unsigned short offset_y;

    unsigned short res_x;
    unsigned short res_y;
    unsigned short refresh;
    unsigned short y_max_offset;
} video_settings_t;

typedef enum {
    OUTPUT_VALID,
    OUTPUT_INVALID
} vsc_output_state_t;

typedef enum {
    VIDEO_SIGNAL_ON,
    VIDEO_SIGNAL_OFF,
    VIDEO_SIGNAL_UNKNOWN
} video_signal_state_t;

typedef enum {
    VSC_SETTING_GLOBAL		= 0x01,
    VSC_SETTING_KVM_LOCAL	= 0x02,
    VSC_SETTING_MODE_LOCAL	= 0x04,
    VSC_SETTING_MODE_ALL	= 0x08
} vsc_setting_type_t;

typedef enum {
    VSC_RESET_SOFTWARE_ONLY,
    VSC_RESET_PROGRAM_FPGA
} vsc_reset_type_t;

#endif /* _PP_VSC_TYPES_EXTERNAL_H */
