#ifndef _MODE_H
#define _MODE_H

#include <lara.h>
#include "context.h"

int  mode_init(void);
void mode_cleanup(void);

sync_detect_result_t sync_detection(vsc_context_t *context);
int sync_measurement(vsc_context_t *context);

#if !defined(PP_FEAT_VSC_PANEL_INPUT)
void sync_configure_input(vsc_context_t *context);
#endif

mode_det_res_t mode_detection(vsc_context_t *context);
void mode_setup(vsc_context_t *context, vsc_mode_t *mode);
int mode_get_res_info(vsc_context_t *context,
		       unsigned short *resX, unsigned short *resY,
		       unsigned short *freqV, unsigned short *freqH);
int mode_save_settings(vsc_context_t *context,
		       unsigned short clocks, unsigned short phase,
		       unsigned short ofsX, unsigned short ofsY);
		       
void mode_reset_current(vsc_context_t *context);
void mode_reset_all(vsc_context_t *context);

void send_video_mode_propchange(vsc_context_t *context);
void invalidate_custom_modes(void);
int mode_get_format(vsc_context_t *context, fb_format_info_t *fb);

#endif /* _MODE_H */
