#ifndef _TIMER_H
#define _TIMER_H

#include <pp/base.h>
#include "context.h"

#define UNSTABLE_TIMER		0
#define POWERDOWN_TIMER		1
#define UNKNOWN_MODE_TIMER	2
#define DIFF_THRESHOLD_TIMER	3
#define AUTO_AA_TIMER		4
#define PRESTABLE_TIMER		5
#define POSTSTABLE_TIMER	6
#define RESET_NO_SIGNAL_TIMER	7
#define UNSTABLE_INSTABLE_TIMER	8
#define VFIFO_RESET_TIMER	9

int  timer_init(vsc_context_t *context, unsigned long tick_ms,
		unsigned long tick_fast_ms);
void timer_cleanup(vsc_context_t *context);
void timer_tick(vsc_context_t *context, timer_tick_t type);
void timer_set(vsc_context_t *context, unsigned char timer,
	       unsigned long expire_in_ms);
void timer_deactivate(vsc_context_t *context, unsigned char timer);
pp_bool_t timer_expired(vsc_context_t *context, unsigned char timer);
pp_bool_t timer_active(vsc_context_t *context, unsigned char timer);
void timer_wait_ms(vsc_context_t *context, unsigned long ms);

#endif /* _TIMER_H */
