#ifndef _VSC_FUNCS_H
#define _VSC_FUNCS_H

#include "context.h"

void vsc_check_version_features(vsc_context_t *context);
vsc_output_state_t vsc_output_state(vsc_context_t *context);
video_signal_state_t vsc_has_signal(vsc_context_t *context);
int vsc_measure_ofs_len(vsc_context_t *context,
			u_int16_t *ofsX, u_int16_t *ofsY, u_int16_t *lenX,
			u_int16_t *totalX, u_int16_t *totalY);
void vsc_set_sync_input(vsc_context_t *context, vsc_hsync_input_t h, vsc_vsync_input_t v);
void vsc_set_sync_sample_input(vsc_context_t *context, vsc_hsync_input_t h, vsc_vsync_input_t v);
void vsc_set_sync_irq_input(vsc_context_t *context, vsc_hsync_input_t h, vsc_vsync_input_t v);
void vsc_set_sync_reg_input(vsc_context_t *context, vsc_hsync_input_t h, vsc_vsync_input_t v);

void vsc_aa_advance(vsc_context_t *context);
void vsc_aa_stop(vsc_context_t *context);

void vsc_update_diff_thresholds(void);
void vsc_update_sun_mode(vsc_context_t *context);
void vsc_update_sync_deltas(vsc_context_t *context);
void vsc_set_diff_threshold(vsc_context_t *context);
void vsc_zero_diff_threshold(vsc_context_t *context);
void vsc_sync_irq_state(vsc_context_t *context, pp_bool_t state);
void vsc_init_sdram(vsc_context_t *context);

/* set functions for settings struct with common interface */ 
int vsc_set_offset_x(vsc_context_t *context, unsigned short offset);   
int vsc_set_offset_y(vsc_context_t *context, unsigned short offset);
int vsc_set_bpt(vsc_context_t *context, unsigned short threshold);
unsigned short vsc_get_offset_x(vsc_context_t *context);
unsigned short vsc_get_offset_y(vsc_context_t *context);
unsigned short vsc_get_bpt(vsc_context_t *context);
void vsc_correct_offsets(vsc_context_t *context);

void vsc_syncs_on(vsc_context_t *context, pp_bool_t *hs, pp_bool_t *vs);
void vsc_sync_check_reset(vsc_context_t *context);

extern const vsc_features_t vsc_features_default;

unsigned char
vsc_use_2nd_sync(vsc_context_t *context);

#endif /* _VSC_FUNCS_H */
