#ifndef _VSC_IO_H
#define _VSC_IO_H

#include <sys/types.h>
#include <pp/base.h>
#include <lara.h>
#include "context.h"

#define VSC_DONT_PROGRAM_FPGA	0
#define VSC_DO_PROGRAM_FPGA	1

#if defined(LARA_KIMMSI) || defined(LARA_KIMSMI) || defined(LARA_KIMAMD) || defined(LARA_KIMINTEL) || defined(__arm__)
# define VSC_DEFAULT_INIT_METHOD	VSC_DONT_PROGRAM_FPGA
# else 
# define VSC_DEFAULT_INIT_METHOD	VSC_DO_PROGRAM_FPGA
#endif

pp_bool_t vsc_initialize(vsc_context_t *context, int do_program_fpga);
u_int32_t vsc_rx_reg(vsc_context_t *context, u_int8_t reg);
u_int32_t vsc_rx_reg_secure(vsc_context_t *context, u_int8_t reg, pp_bool_t *error_occured);
u_int32_t vsc_rx_reg_shadowed(vsc_context_t *context, u_int8_t reg);
void vsc_tx_reg(vsc_context_t *context, u_int8_t reg, u_int32_t data);
void vsc_tx_masked(vsc_context_t *context, u_int8_t reg,
		   u_int32_t data, u_int32_t mask);
int  vsc_get_sync_irq(vsc_context_t *context, pp_bool_t dowait);
int  vsc_get_ofs_len_measures(vsc_context_t *context, vsc_measures_t *measures);

#endif /* _VSC_IO_H */
