#ifndef __ENUMERATE_SESSION_H
#define __ENUMERATE_SESSION_H

#include "uuid.h"
#include "resource.h"

/* a wsman enumerate session */
typedef struct {
    unsigned int id;
    
    enum_type_t type;
    char last_context[UUID_LENGTH];
    wsman_resource_t *resource;
    wsman_instance_t *instance;
    int last_timestamp;
} enumerate_session_t;

/* locking and unlocking */
void lock_sessions(void);
void unlock_sessions(void);

/* create, update and delete sessions
   NOTE: when working with sessions, the sessions must be locked!
         there is a thread which removes dead sessions! */
enumerate_session_t * get_session(char *context);
enumerate_session_t * create_session(enum_type_t type, char *context, wsman_resource_t *res, wsman_instance_t *instance);
enumerate_session_t * update_session(enumerate_session_t *session, char *context, wsman_instance_t *instance);
int destroy_session(enumerate_session_t *session);

/* session initializing and cleanup */
int enumerate_session_init(void);
void enumerate_session_cleanup(void);

#endif /* __ENUMERATE_SESSION_H */
