#ifndef __FAULT_H
#define __FAULT_H

#include <pp/base.h>

#include "xml_writer.h"

/******************************************************************************
* fault constants                                                             *
******************************************************************************/

/* fault main codes */
#define FAULT_SUCCESS					0
#define FAULT_NOT_UNDERSTOOD				1 
#define FAULT_ACCESS_DENIED				2 
#define FAULT_NO_ACK					3 
#define FAULT_ACTION_NOT_SUPPORTED			4 
#define FAULT_CONCURRENCY				5 
#define FAULT_ALREADY_EXISTS				6 
#define FAULT_CANNOT_PROCESS_FILTER			7 
#define FAULT_DELIVERY_MODE_REQUESTED_UNAVAILABLE	8 
#define FAULT_DELIVERY_REFUSED				9 
#define FAULT_DESTINATION_UNREACHABLE			10
#define FAULT_ENCODING_LIMIT				11
#define FAULT_ENDPOINT_UNAVAILABLE			12
#define FAULT_EVENT_SOURCE_UNABLE_TO_PROCESS		13
#define FAULT_FILTER_DIALECT_REQUESTED_UNAVAILABLE	14
#define FAULT_FILTERING_NOT_SUPPORTED_WSE		15
#define FAULT_FILTERING_NOT_SUPPORTED_WSEN		16
#define FAULT_FILTERING_REQUESTED_UNAVAILABLE		17
#define FAULT_INTERNAL_ERROR				18
#define FAULT_INVALID_BOOKMARK				19
#define FAULT_INVALID_ENUMERATION_CONTEXT		20
#define FAULT_INVALID_EXPIRATION_TIME_WSE		21
#define FAULT_INVALID_EXPIRATION_TIME_WSEN		22
#define FAULT_INVALID_MESSAGE				23
#define FAULT_INVALID_MESSAGE_INFORMATION_HEADER	24
#define FAULT_INVALID_OPTIONS				25
#define FAULT_INVALID_PARAMETER				26
#define FAULT_INVALID_REPRESENTATION			27
#define FAULT_INVALID_SELECTORS				28
#define FAULT_MESSAGE_INFORMATION_HEADER_REQUIRED	29
#define FAULT_QUOTA_LIMIT				30
#define FAULT_RENAME_FAILURE				31
#define FAULT_SCHEMA_VALIDATION_ERROR			32
#define FAULT_TIMED_OUT_WSEN				33
#define FAULT_TIMED_OUT_WSMAN				34
#define FAULT_UNABLE_TO_RENEW				35
#define FAULT_UNSUPPORTED_EXPIRATION_TYPE_WSE		36
#define FAULT_UNSUPPORTED_EXPIRATION_TYPE_WSEN		37
#define FAULT_UNSUPPORTED_FEATURE			38

#define NUMBER_FAULTS	(FAULT_UNSUPPORTED_FEATURE + 1)

/* fault details codes */
/* FAULT_ACTION_NOT_SUPPORTED */
#define FAULT_DETAIL_NONE				0
#define FAULT_DETAIL_NOT_ACTION_MISMATCH		1
#define FAULT_DETAIL_READ_ONLY				2

/* FAULT_DESTINATION_UNREACHABLE: */
#define FAULT_DETAIL_INVALID_RESOURCE_URI		0

/* FAULT_ENCODING_LIMIT */
#define FAULT_DETAIL_URI_LIMIT_EXCEEDED			0
#define FAULT_DETAIL_MAX_ENVELOPE_SIZE			1
#define FAULT_DETAIL_MAX_ENVELOPE_SIZE_EXCEEDED		2
#define FAULT_DETAIL_SERVICE_ENVELOPE_LIMIT		3
#define FAULT_DETAIL_SELECTOR_LIMIT			4
#define FAULT_DETAIL_OPTION_LIMIT			5
#define FAULT_DETAIL_CHARACTER_SET			6
#define FAULT_DETAIL_UNREPORTABLE_SUCCESS		7
#define FAULT_DETAIL_WHITESPACE				8
#define FAULT_DETAIL_ENCODING_TYPE			9
#define FAULT_DETAIL_MINIMUM_ENVELOPE_LIMIT		10

/* FAULT_ENDPOINT_UNAVAILABLE */
//#define FAULT_DETAIL_NONE				0
#define FAULT_DETAIL_RESOURCE_OFFLINE			1

/* FAULT_EVENT_SOURCE_UNABLE_TO_PROCESS */
//#define FAULT_DETAIL_NONE				0
#define FAULT_DETAIL_UNUSABLE_ADDRESS			1

/* FAULT_FILTERING_REQUESTED_UNAVAILABLE */
//#define FAULT_DETAIL_NONE				0
#define FAULT_DETAIL_FILTERING_REQUIRED			1

/* FAULT_INVALID_BOOKMARK */
#define FAULT_DETAIL_BOOKMARK_EXPIRED			0
#define FAULT_DETAIL_BOOKMARK_INVALID			1

/* FAULT_INVALID_OPTIONS */
#define FAULT_DETAIL_OPTION_NOT_SUPPORTED		0
#define FAULT_DETAIL_OPTION_INVALID_NAME		1
#define FAULT_DETAIL_OPTION_INVALID_VALUE		2

/* FAULT_INVALID_PARAMETER */
#define FAULT_DETAIL_PARAMETER_TYPE_MISMATCH		0
#define FAULT_DETAIL_PARAMETER_INVALID_NAME		1

/* FAULT_INVALID_REPRESENTATION */
#define FAULT_DETAIL_REPRESENTATION_INVALID_VALUES	0
#define FAULT_DETAIL_REPRESENTATION_MISSING_VALUES	1
#define FAULT_DETAIL_REPRESENTATION_INVALID_NAMESPACE	2
#define FAULT_DETAIL_REPRESENTATION_INVALID_FRAGMENT	3

/* FAULT_INVALID_SELECTORS */
//#define FAULT_DETAIL_NONE				0
#define FAULT_DETAIL_SELECTOR_INSUFFICIENT_SELECTORS	1
#define FAULT_DETAIL_SELECTOR_UNEXPECTED_SELECTORS	2
#define FAULT_DETAIL_SELECTOR_TYPE_MISMATCH		3
#define FAULT_DETAIL_SELECTOR_INVALID_VALUE		4
#define FAULT_DETAIL_SELECTOR_AMBIGUOUS_SELECTORS	5
#define FAULT_DETAIL_SELECTOR_DUPLICATE_SELECTORS	6

/* FAULT_RENAME_FAILURE */
//#define FAULT_DETAIL_INVALID_RESOURCE_URI		0
#define FAULT_DETAIL_TARGET_ADDRESS_EXISTS		1
#define FAULT_DETAIL_RENAME_INVALID_ADDRESS		2
#define FAULT_DETAIL_INVALID_SELECTOR_ASSIGNMENT	3

/* FAULT_UNSUPPORTED_FEATURE */
#define FAULT_DETAIL_UNSUPPORTED_AUTHORIZATION_MODE	0
#define FAULT_DETAIL_UNSUPPORTED_ADDRESSING_MODE	1 
#define FAULT_DETAIL_UNSUPPORTED_ACK			2 
#define FAULT_DETAIL_UNSUPPORTED_OPERATION_TIMEOUT	3 
#define FAULT_DETAIL_UNSUPPORTED_LOCALE			4 
#define FAULT_DETAIL_UNSUPPORTED_EXPIRATION_TIME	5 
#define FAULT_DETAIL_UNSUPPORTED_FRAGMENT_LEVEL_ACCESS	6 
#define FAULT_DETAIL_UNSUPPORTED_DELIVERY_RETRIES	7 
#define FAULT_DETAIL_UNSUPPORTED_HEARTBEATS		8 
#define FAULT_DETAIL_UNSUPPORTED_BOOKMARKS		9
#define FAULT_DETAIL_UNSUPPORTED_MAX_ELEMENTS		10
#define FAULT_DETAIL_UNSUPPORTED_MAX_TIME		11
#define FAULT_DETAIL_UNSUPPORTED_MAX_ENVELOPE_SIZE	12
#define FAULT_DETAIL_UNSUPPORTED_MAX_ENVELOPE_POLICY	13
#define FAULT_DETAIL_UNSUPPORTED_FILTERING_REQUIRED	14
#define FAULT_DETAIL_UNSUPPORTED_INSECURE_ADDRESS	15
#define FAULT_DETAIL_UNSUPPORTED_FORMAT_MISMATCH	16
#define FAULT_DETAIL_UNSUPPORTED_FORMAT_SECURITY_TOKEN	17
#define FAULT_DETAIL_UNSUPPORTED_MISSING_VALUES		18
#define FAULT_DETAIL_UNSUPPORTED_INVALID_VALUES		19
#define FAULT_DETAIL_UNSUPPORTED_INVALID_NAMESPACE	20
#define FAULT_DETAIL_UNSUPPORTED_RENAME			21
#define FAULT_DETAIL_UNSUPPORTED_OPTION_SET		22

/******************************************************************************
* fault functions                                                             *
******************************************************************************/

/* generate a fault message */
void generate_fault_message(xml_writer_t response, char **fault_uri,
			    int fault_code, int fault_subcode,
			    char *fault_detail);

#endif /* __FAULT_H */
