#include <stdio.h>

#include "wsman.h"
#include "debug.h"
#include "resource.h"
#include "res_dummy.h"
#include "standard_actions.h"

#if USE_DUMMY_RESOURCE

/* dummy "acme" disk resource */
static char * disk_kw_words_acme[] = { "Disk", "Storage", NULL };
static char * disk_kw_words_widg[] = { "DiskDrive", NULL };

static wsman_keyword_t disk_kw[] = {
    { "acme", "http://keywords.acme.com/2005/02/hardware", disk_kw_words_acme },
    { "widg", "http://keywords.widgets.com/2004/10/storage/keywords", disk_kw_words_widg },
    { NULL, NULL, NULL }
};

static wsman_action_t disk_act_0[] = {
    { ACTION_URI_GET, NULL },
    { ACTION_URI_PUT, NULL },
    { NULL, NULL }
};
static char * disk_sel_0[] = { "s1", NULL };
static char * disk_opt_0[] = { "os1", NULL };

static wsman_schema_ref_t disk_sc_0[] = {
    {
    	uri_prefix:		"ac",
    	uri:			"http://schemas.acme.com/2005/02/hardware",
    	location:		NULL,
    	schema:			"PhysDisk",
    },
    { NULL, NULL, NULL, NULL },
};

static char * disk_filter_0[] = { "http://www.w3.org/TR/1999/REC-xpath-19991116", NULL };
static char * disk_del_0[] = { "2005/02/management/Pull", "2004/08/eventing/DeliveryModes/Push", NULL };

static wsman_action_t disk_act_1[] = {
    { "http://schemas.acme.com/2005/02/hardware/wsdl/reset", NULL },
    { "http://schemas.acme.com/2005/02/hardware/wsdl/format", NULL },
    { "http://schemas.acme.com/2005/02/hardware/wsdl/powerOff", NULL },
    { "http://schemas.acme.com/2005/02/hardware/wsdl/powerOn", NULL },
    { NULL, NULL }
};

static wsman_operation_t disk_op[] = {
    {
    	wsdl_port:		NULL,
    	wsdl_ref:		NULL,
    	actions:		disk_act_0,
    	selector_set_ref:	disk_sel_0,
    	option_set_ref:		disk_opt_0,
    	schema_ref:		disk_sc_0,
    	filter_dialects:	disk_filter_0,
    	filters_required:	1,
    	delivery_modes:		disk_del_0,
    },
    {
    	wsdl_port:		"DiskOps",
    	wsdl_ref:		"http://schemas.acme.com/2005/02/hardware/wsdl",
    	actions:		disk_act_1,
    	selector_set_ref:	NULL,
    	option_set_ref:		NULL,
    	schema_ref:		NULL,
    	filter_dialects:	NULL,
    	filters_required:	0,
    	delivery_modes:		NULL,
    },
    {
    	wsdl_port:		NULL,
    	wsdl_ref:		NULL,
    	actions:		NULL,
    	selector_set_ref:	NULL,
    	option_set_ref:		NULL,
    	schema_ref:		NULL,
    	filter_dialects:	NULL,
    	filters_required:	0,
    	delivery_modes:		NULL,
    }
};

static wsman_selector_t sel0[] = {
    { "sel1", "xs:string", "blablabla" },
    { "sel2", "xs:string", "blubbblubb" },
    { NULL, NULL, NULL }
};

static wsman_selector_t sel1[] = {
    { "sel3", NULL, NULL },
    { NULL, NULL, NULL }
};

static wsman_selector_set_t disk_sel[] = {
    {
    	set_name:		"s1",
    	selectors:		sel0,
    },
    {
    	set_name:		"s2",
    	selectors:		sel1,
    },
    {
    	NULL, NULL
    },
};

static wsman_option_t opt0[] = {
    { "option1", "xs:string", "blubb blubb" },
    { "option2", "xs:string", "tri tra trulalla" },
    { NULL, NULL, NULL }
};

static wsman_option_t opt1[] = {
    { "option3", NULL, "abcdefg" },
    { NULL, NULL, NULL }
};

static wsman_option_set_t disk_opt[] = {
    {
    	set_name:		"os1",
    	options:		opt0,
    },
    {
    	set_name:		"os2",
    	options:		opt1,
    },
    {
    	NULL, NULL
    },
};

static wsman_relship_t disk_rel[] = {
    {
    	type:			"relVendorURL",
    	role:			"External",
    	ref:			"http://www.acme.com/default.htm",
    },
    {
    	type:			"relVendorEmail",
    	role:			"External",
    	ref:			"mailto:user@host?subject=WSManUserContact",
    },
    {
    	type:			"relExtends",
    	role:			"Catalog",
    	ref:			"http://schemas.acme.com/2005/02/samples/baseStorageDevice",
    },
    {
    	NULL, NULL, NULL
    },
};

static wsman_resource_t dummy_resource = {
    resource_uri:	"http://schemas.acme.com/2005/02/samples/physicalDisk",
    notes:		"Describes access to a physical disk unit",
    vendor:		"Acme Corporation",
    display_name:	"ACME Super Disk",
    
    keywords:		disk_kw,
    ops:		disk_op,
    sel_set:		disk_sel,
    opt_set:		disk_opt,

    relships:		disk_rel,
    
    open_content:	NULL,
};

static int add_dummy_resource_dyn() {
    wsman_resource_t *res = create_resource(NULL, "http://schemas.acme.com/2005/02/samples/physicalDisk");

    resource_set_notes(res, "Describes access to a physical disk unit");
    resource_set_vendor(res, "Acme Corporation");
    resource_set_dispname(res, "ACME Super Disk");
    
    wsman_keyword_t *kw1 = add_keywords(res, "acme", "http://keywords.acme.com/2005/02/hardware");
    add_keyword(kw1, "Disk");
    add_keyword(kw1, "Storage");
    wsman_keyword_t *kw2 = add_keywords(res, "widg", "http://keywords.widgets.com/2004/10/storage/keywords");
    add_keyword(kw2, "DiskDrive");
    
    wsman_operation_t *op1 = add_operation(res, NULL, NULL);
    op_add_action(op1, ACTION_URI_GET, NULL);
    op_add_action(op1, ACTION_URI_PUT, NULL);
    op_add_selsetref(op1, "s1");
    op_add_optsetref(op1, "os1");
    op_add_schemaref(op1, "ac", "http://schemas.acme.com/2005/02/hardware", NULL, "PhysDisk");
    op_add_filter_dialect(op1, "http://www.w3.org/TR/1999/REC-xpath-19991116");
    op_set_filters_required(op1, 1);
    op_add_delivery_mode(op1, "2005/02/management/Pull");
    op_add_delivery_mode(op1, "2004/08/eventing/DeliveryModes/Push");
    
    wsman_operation_t *op2 = add_operation(res, "DiskOps", "http://schemas.acme.com/2005/02/hardware/wsdl");
    op_add_action(op2, "http://schemas.acme.com/2005/02/hardware/wsdl/reset", NULL);
    op_add_action(op2, "http://schemas.acme.com/2005/02/hardware/wsdl/format", NULL);
    op_add_action(op2, "http://schemas.acme.com/2005/02/hardware/wsdl/powerOff", NULL);
    op_add_action(op2, "http://schemas.acme.com/2005/02/hardware/wsdl/powerOn", NULL);
    
    wsman_selector_set_t *sel1 = resource_add_selectorset(res, "s1");
    add_selector(sel1, "sel1", "xs:string", "blablabla");
    add_selector(sel1, "sel2", "xs:string", "blubbblubb");
    wsman_selector_set_t *sel2 = resource_add_selectorset(res, "s2");
    add_selector(sel2, "sel3", NULL, NULL);
    
    wsman_option_set_t *opt1 = resource_add_optionset(res, "os1");
    add_option(opt1, "option1", "xs:string", "blubb blubb");
    wsman_option_set_t *opt2 = resource_add_optionset(res, "os2");
    add_option(opt2, "option2", NULL, NULL);
    
    resource_add_relationship(res, "relVendorURL", "External", "http://www.acme.com/default.htm");
    resource_add_relationship(res, "relVendorEmail", "External", "mailto:user@host?subject=WSManUserContact");
    resource_add_relationship(res, "relExtends", "Catalog", "http://schemas.acme.com/2005/02/samples/baseStorageDevice");

    if (0) {
    	delete_resource(res);
    	return 0;
    } else {
    	return add_resource(res, 1);
    }
}

int res_dummy_init(void) {
    D(D_BLABLA, "Adding Dummy resource\n");
    add_resource(&dummy_resource, 1);
    
    add_dummy_resource_dyn();
    
    return 0;
}

void res_dummy_cleanup(void) {
    /* nothing to do */
}

#endif /* USE_DUMMY_RESOURCE */
