#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>

#include <pp/base.h>

#include "debug.h"
#include "wsman.h"
#include "uuid.h"

static int rand_fd = -1;

int uuid_init(void) {
    char *filename = "/dev/urandom";
    
    rand_fd = open(filename, O_RDONLY);
    if (rand_fd == -1) {
    	D(D_ERROR, "Could not open %s.\n", filename);
    	return -1;
    }
    return 0;
}

void uuid_cleanup(void) {
    if (rand_fd != -1) {
    	close(rand_fd);
    }
}

char * build_uuid(char *uuid_target) {
    char rand_bytes[16];
    
    memset(rand_bytes, 0, sizeof(rand_bytes));
    read(rand_fd, rand_bytes, 16);

    memset(uuid_target, 0, UUID_LENGTH);
    snprintf(uuid_target, UUID_LENGTH,
    	"urn:uuid:%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x",
    	rand_bytes[0], rand_bytes[1], rand_bytes[2], rand_bytes[3],
    	rand_bytes[4], rand_bytes[5], rand_bytes[6], rand_bytes[7],
    	rand_bytes[8], rand_bytes[9], rand_bytes[10], rand_bytes[11],
    	rand_bytes[12], rand_bytes[13], rand_bytes[14], rand_bytes[15]);
    
    return uuid_target;
}
