#include <pp/base.h>

#include "debug.h"
#include "ezxml.h"
#include "xml_parser.h"
#include "xml_writer.h"

xml_writer_t print_xml_full_tag(xml_writer_t xml, const char *tag_namespace,
				const char *tagname, const char *content,
				const char **attribs, int no_attribs) {
    int i;
    ezxml_t ret;
    char tmp[256], tmp2[256];
    
    assert(tagname);

    if (tag_namespace && tag_namespace[0] != '\0') {
    	snprintf(tmp, sizeof(tmp), "%s:%s", tag_namespace, tagname);
    } else {
    	snprintf(tmp, sizeof(tmp), "%s", tagname);
    }
    if (xml) {
    	ret = ezxml_add_child_d(xml, tmp, strlen(xml->txt));
    } else {
    	ret = ezxml_new_d(tmp);
    }
    assert(ret);
    
    if (content) {
    	ezxml_set_txt_d(ret, content);
    }
    
    for (i = 0; (no_attribs < 0 && attribs && attribs[i] && attribs[i + 1] && attribs[i + 2] && attribs[i + 3]) ||
                                   (no_attribs >= 0 && i < (no_attribs * 4)); i += 4) {
    	if (!attribs[i + 1] || !attribs[i + 3]) {
    	    continue;
    	}
    	if (attribs[i] && attribs[i][0] != '\0') {
    	    snprintf(tmp, sizeof(tmp), "%s:%s", attribs[i], attribs[i + 1]);
    	} else {
    	    snprintf(tmp, sizeof(tmp), "%s", attribs[i + 1]);
    	}
    	if (attribs[i + 2] && attribs[i + 2][0] != '\0') {
    	    snprintf(tmp2, sizeof(tmp2), "%s:%s", attribs[i + 2], attribs[i + 3]);
    	} else {
    	    snprintf(tmp2, sizeof(tmp2), "%s", attribs[i + 3]);
    	}
    	ezxml_set_attr_d(ret, tmp, tmp2);
    }

    return ret;
}

void print_xml_text(xml_writer_t xml, const char *content) {
    assert(xml && content);
    
    ezxml_set_txt_d(xml, content);
}

void copy_xml(xml_writer_t dest, xml_parser_t src, int childs_only) {
    /* copy the tag itself */
    if (!childs_only) {
    	dest = ezxml_add_child_d(dest, src->name, strlen(dest->txt));
    	if (src->txt) ezxml_set_txt_d(dest, src->txt);
    	if (src->attr && src->attr[0]) {
    	    int i = 0;
    	    while (src->attr[i]) {
    	    	ezxml_set_attr_d(dest, src->attr[i], src->attr[i + 1]);
    	    	i += 2;
    	    }
    	}
    }
    
    /* copy all child tags */
    src = src->child;
    while (src) {
    	copy_xml(dest, src, 0);
    	src = src->sibling ? src->sibling : src->next;
    }
}

size_t xml_writer_to_strstream(xml_writer_t xml, pp_strstream_t *stream, int encoding) {
    size_t len;
    char *s = ezxml_toxml(xml, &len, encoding);
    pp_strstream_init(stream);
    pp_strwrite(stream, s, len);
    free(s);
    return len;
}

char *xml_writer_to_string(xml_writer_t xml, int encoding, size_t *size) {
    char *ret = ezxml_toxml(xml, size, encoding);
    if (ret) {
    	(*size)--;	// terminating NULL character - not requested
    }
    return ret;
}

void remove_xml(xml_writer_t main UNUSED, xml_writer_t to_remove) {
    ezxml_remove(to_remove);
}

void free_xml(xml_writer_t xml) {
    if (xml) ezxml_free(xml);
}
