#ifndef __XMLWRITER_H
#define __XMLWRITER_H

#include <pp/base.h>

#include "ezxml.h"
#include "xml_parser.h"

typedef ezxml_t xml_writer_t;

/* generate our structures from XML tags */
#define print_xml_tag(xml, tag_namespace, tagname, content, attr...)				\
    ({												\
    	xml_writer_t __ret;									\
    	const char *attr_array[] = { attr, NULL };							\
    	__ret = print_xml_full_tag(xml, tag_namespace, tagname, content, attr_array,		\
    			   (sizeof(attr_array) / sizeof(attr_array[0]) - 1) / 4);		\
    	__ret;											\
    })

#define printf_xml_tag(xml, tag_namespace, tagname, content_fmt, args...)			\
    ({												\
    	xml_writer_t __ret;									\
    	pp_strstream_t s = PP_STRSTREAM_INITIALIZER;						\
    	pp_strappendf(&s, content_fmt, args);							\
    	__ret = print_xml_full_tag(xml, tag_namespace, tagname, s.buf, NULL, 0);		\
    	pp_strstream_free(&s);									\
    	__ret;											\
    })

xml_writer_t print_xml_full_tag(xml_writer_t xml,	/* destination (xml tag where the new tag is added); NULL to create root tag */
				const char *tag_namespace,	/* <tag_namespace:tagname...> */
				const char *tagname,		/* <tagname...> */
				const char *content,		/* tag text (NULL or empty string if nothing) */
				const char **attribs,		/* tag attributes { ns (may be empty, not NULL), name, value, ns, name, value, ... NULL } */
				int no_attribs		/* number of attributes sets; if < 0, determined from attribs (NULL terminated) */
				);

#define printf_xml_text(xml, content_fmt, args...)		\
    ({								\
    	pp_strstream_t s = PP_STRSTREAM_INITIALIZER;		\
    	pp_strappendf(&s, content_fmt, args);			\
    	print_xml_text(xml, s.buf);				\
    	pp_strstream_free(&s);					\
    })

void print_xml_text(xml_writer_t xml, const char *content);

/* copy an XML element to another */
void copy_xml(xml_writer_t dest, xml_parser_t src, int childs_only);

/* printing XML tags from our structure */
size_t xml_writer_to_strstream(xml_writer_t xml, pp_strstream_t *stream, int encoding);
char *xml_writer_to_string(xml_writer_t xml, int encoding, size_t *size);

/* removing tags from structure */
void remove_xml(xml_writer_t main, xml_writer_t to_remove);

void free_xml(xml_writer_t xml);

#endif // __XMLWRITER_H
