#include "iomem.h"

static voidpf ZCALLBACK fopen_file_func (const void * data, uLong data_len)
{
	int i;
	unz_data *d=NULL;
		
    d = (unz_data*)malloc(sizeof(unz_data)); 
    if(d== NULL)
    	return 0;
        	
    d->filedata		= (const u_char *)data;
    d->current_pos 	= (const u_char *)data;
    d->data_size	= data_len;
    
    
    for(i=0;i<(int )data_len;i++)
    {
    	d->current_pos ++;
    }
    d->current_pos --;
    d->last_pos 	= d->current_pos;
    d->current_pos 	= d->filedata;
    
    return (voidpf *)d;
}


static uLong ZCALLBACK fread_file_func (voidpf stream, void * buf, uLong size)
{
    uLong ret=0;
    int i;
    unz_data *d = (unz_data*) stream;
    
    
    void *p;
    
    p = memcpy(buf,d->current_pos,size);
    if(p==buf)
		ret = size;   
	        
    for(i=0;i<(int )size;i++)
    {
      	d->current_pos++;
    }
    return ret;
}


static uLong ZCALLBACK fwrite_file_func (voidpf stream, const void * buf, uLong size)
{
    uLong ret;
    ret = fwrite(buf, 1, (size_t)size, (FILE *)stream);
    return ret;
}

static long ZCALLBACK ftell_file_func (voidpf stream)
{
    unz_data *d = (unz_data *) stream;
    long ret = (long) (d->current_pos - d->filedata);
    
    return ret;
}

static long ZCALLBACK fseek_file_func (voidpf stream, uLong offset, int origin)
{
    unz_data *d=(unz_data*)stream;
    long ret;
    
    switch (origin)
    {
    case ZLIB_FILEFUNC_SEEK_CUR :		// 1
        d->current_pos = d->current_pos + offset;
        break;
    case ZLIB_FILEFUNC_SEEK_END :		// 2
        d->current_pos = d->last_pos - offset;
        break;
    case ZLIB_FILEFUNC_SEEK_SET :		// 0
        d->current_pos = d->filedata + offset;
        break;
    default: return -1;
    }
    ret = 0;
    return ret;
}

static int ZCALLBACK fclose_file_func (voidpf stream)
{
    int ret=0;
    unz_data *d = (unz_data*)stream;
    free(d);
    return ret;
}

static int ZCALLBACK ferror_file_func (voidpf stream)
{
    int ret;
    ret = ferror((FILE *)stream);
    return ret;
}

void fill_fopen_filefunc (zlib_filefunc_def * pzlib_filefunc_def)
{
    pzlib_filefunc_def->zopen_file = fopen_file_func;
    pzlib_filefunc_def->zread_file = fread_file_func;
    pzlib_filefunc_def->zwrite_file = fwrite_file_func;
    pzlib_filefunc_def->ztell_file = ftell_file_func;
    pzlib_filefunc_def->zseek_file = fseek_file_func;
    pzlib_filefunc_def->zclose_file = fclose_file_func;
    pzlib_filefunc_def->zerror_file = ferror_file_func;
    pzlib_filefunc_def->opaque = NULL;
}
