#ifndef _PP_ZIP_IOMEM_H
#define _PP_ZIP_IOMEM_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "zlib.h"

#ifndef SEEK_CUR
#define SEEK_CUR    1
#endif

#ifndef SEEK_END
#define SEEK_END    2
#endif

#ifndef SEEK_SET
#define SEEK_SET    0
#endif

typedef struct
{
    const unsigned char * filedata;	/* data of the zip file 	 */
    const unsigned char * current_pos;	/* current data pointer 	 */
    const unsigned char * last_pos;	/* pointer to end of data 	 */
    uLong 	data_size;		/* size of the uploaded file */
} unz_data;


#define ZLIB_FILEFUNC_SEEK_CUR (1)
#define ZLIB_FILEFUNC_SEEK_END (2)
#define ZLIB_FILEFUNC_SEEK_SET (0)

#define ZLIB_FILEFUNC_MODE_READ      (1)
#define ZLIB_FILEFUNC_MODE_WRITE     (2)
#define ZLIB_FILEFUNC_MODE_READWRITEFILTER (3)

#define ZLIB_FILEFUNC_MODE_EXISTING (4)
#define ZLIB_FILEFUNC_MODE_CREATE   (8)


#ifndef ZCALLBACK

#if (defined(WIN32) || defined (WINDOWS) || defined (_WINDOWS)) && defined(CALLBACK) && defined (USEWINDOWS_CALLBACK)
#define ZCALLBACK CALLBACK
#else
#define ZCALLBACK
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef voidpf (ZCALLBACK *open_file_func) OF((const void * data, uLong data_len));
typedef uLong  (ZCALLBACK *read_file_func) OF((voidpf stream, void* buf, uLong size));
typedef uLong  (ZCALLBACK *write_file_func) OF((voidpf stream, const void* buf, uLong size));
typedef long   (ZCALLBACK *tell_file_func) OF((voidpf stream));
typedef long   (ZCALLBACK *seek_file_func) OF((voidpf stream, uLong offset, int origin));
typedef int    (ZCALLBACK *close_file_func) OF((voidpf stream));
typedef int    (ZCALLBACK *testerror_file_func) OF((voidpf stream));

typedef struct zlib_filefunc_def_s
{
    open_file_func      zopen_file;
    read_file_func      zread_file;
    write_file_func     zwrite_file;
    tell_file_func      ztell_file;
    seek_file_func      zseek_file;
    close_file_func     zclose_file;
    testerror_file_func zerror_file;
    voidpf              opaque;
} zlib_filefunc_def;



void fill_fopen_filefunc OF((zlib_filefunc_def* pzlib_filefunc_def));

#define ZREAD(filefunc,filestream,buf,size) ((*((filefunc).zread_file))(filestream,buf,size))
#define ZWRITE(filefunc,filestream,buf,size) ((*((filefunc).zwrite_file))(filestream,buf,size))
#define ZTELL(filefunc,filestream) ((*((filefunc).ztell_file))(filestream))
#define ZSEEK(filefunc,filestream,pos,mode) ((*((filefunc).zseek_file))(filestream,pos,mode))
#define ZCLOSE(filefunc,filestream) ((*((filefunc).zclose_file))(filestream))
#define ZERROR(filefunc,filestream) ((*((filefunc).zerror_file))(filestream))


#ifdef __cplusplus
}
#endif

#endif /* _PP_ZIP_IOMEM_H */
