/*
 *  linux/arch/armnommu/mach-faraday/platform-a320/ahb_intc.c
 *
 *  Faraday AHB DMA Interrupt Process Driver Implementation
 *
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  
 * ChangeLog
 * 
 *  Peter Liao 09/28/2005 Created
 */

#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <asm/io.h>

#include <asm/mach/irq.h>
#include <asm/arch/intc.h>
#include <asm/arch/spec.h>

/*
 * Level trigger IRQ chip methods
 */
static void intc_ftdmac020_level_ack_mask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        // Ack parent chip (recursively)
	irq_desc[parent_chip_irq].chip->ack(parent_chip_irq);
}

static void intc_ftdmac020_level_mask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        // Mask parent chip (recursively)
	irq_desc[parent_chip_irq].chip->mask(parent_chip_irq);
}

static void intc_ftdmac020_level_unmask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        //printk("intc_ftdmac020_level_unmask_irq:%d,parent=%d\n",irq, parent_chip_irq);
        // Unmask parent chip (recursively)
	irq_desc[parent_chip_irq].chip->unmask(parent_chip_irq);
}

static struct irqchip intc_ftdmac020_level_chip = {
	.ack	= intc_ftdmac020_level_ack_mask_irq,
	.mask	= intc_ftdmac020_level_mask_irq,
	.unmask = intc_ftdmac020_level_unmask_irq
};

int __init intc_ftdmac020_init_irq(void)
{
        int i;
    
        /* Register all IRQ */
        for (i = DMAC_FTDMAC020_IRQ0 ;
             i < DMAC_FTDMAC020_IRQ0 + DMAC_FTDMAC020_IRQ_COUNT;
             i++ )
        {
                // level trigger
                set_irq_chip(i, &intc_ftdmac020_level_chip);
                set_irq_handler(i, do_level_IRQ);
                set_irq_flags(i, IRQF_VALID | IRQF_PROBE);
                set_irq_chipdata( i, (void*) PLATFORM_AHBDMA_IRQ );
        }

        return 0;
}

arch_initcall( intc_ftdmac020_init_irq );
