/*
 *  linux/arch/armnommu/mach-faraday/platform-a320/apb_intc.c
 *
 *  Faraday AHB DMA Interrupt Process Driver Implementation
 *
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  
 * ChangeLog
 * 
 *  Peter Liao 09/28/2005 Created
 */

#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <asm/io.h>

#include <asm/mach/irq.h>
#include <asm/arch/intc.h>
#include <asm/arch/spec.h>

#ifdef CONFIG_PLATFORM_FIA321
/*
 * Level trigger IRQ chip methods for A321 APBDMA
 */
static void fia321_intc_ftapbbrg020s_level_ack_mask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        // Ack parent chip (recursively)
	irq_desc[parent_chip_irq].chip->ack(parent_chip_irq);
}

static void fia321_intc_ftapbbrg020s_level_mask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        // Mask parent chip (recursively)
	irq_desc[parent_chip_irq].chip->mask(parent_chip_irq);
}

static void fia321_intc_ftapbbrg020s_level_unmask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
	//printk("fia321_intc_ftapbbrg020s_level_unmask_irq:%d,parent=%d\n",irq, parent_chip_irq);
        // Unmask parent chip (recursively)
	irq_desc[parent_chip_irq].chip->unmask(parent_chip_irq);
}

static struct irqchip fia321_intc_ftapbbrg020s_level_chip = {
	.ack	= fia321_intc_ftapbbrg020s_level_ack_mask_irq,
	.mask	= fia321_intc_ftapbbrg020s_level_mask_irq,
	.unmask = fia321_intc_ftapbbrg020s_level_unmask_irq
};

int __init fia321_intc_ftapbbrg020s_init_irq(void)
{
        int i;
	/* Register all IRQ */
        for (i = APBBRG_FTAPBBRG020S_1_IRQ0 ;
             i < APBBRG_FTAPBBRG020S_1_IRQ0 + APBBRG_FTAPBBRG020S_IRQ_COUNT;
             i++ )
        {
                // level trigger
                set_irq_chip(i, &fia321_intc_ftapbbrg020s_level_chip);
                set_irq_handler(i, do_level_IRQ);
                set_irq_flags(i, IRQF_VALID | IRQF_PROBE);
                set_irq_chipdata( i, (void*) PLATFORM_FIA321_IRQ_BASE+PLATFORM_FIA321_APBDMA_IRQ );
        }

        return 0;
}
arch_initcall( fia321_intc_ftapbbrg020s_init_irq );
#endif /* CONFIG_PLATFORM_FIA321 */

#ifdef CONFIG_PLATFORM_APBDMA
/*
 * Level trigger IRQ chip methods for A321 APBDMA
 */
static void intc_ftapbbrg020s_level_ack_mask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        // Ack parent chip (recursively)
	irq_desc[parent_chip_irq].chip->ack(parent_chip_irq);
}

static void intc_ftapbbrg020s_level_mask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        // Mask parent chip (recursively)
	irq_desc[parent_chip_irq].chip->mask(parent_chip_irq);
}

static void intc_ftapbbrg020s_level_unmask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
	//printk("intc_ftapbbrg020s_level_unmask_irq:%d,parent=%d\n",irq, parent_chip_irq);
        // Unmask parent chip (recursively)
	irq_desc[parent_chip_irq].chip->unmask(parent_chip_irq);
}

static struct irqchip intc_ftapbbrg020s_level_chip = {
	.ack	= intc_ftapbbrg020s_level_ack_mask_irq,
	.mask	= intc_ftapbbrg020s_level_mask_irq,
	.unmask = intc_ftapbbrg020s_level_unmask_irq
};

int __init intc_ftapbbrg020s_init_irq(void)
{
        int i;
	/* Register all IRQ */
        for (i = APBBRG_FTAPBBRG020S_0_IRQ0 ;
             i < APBBRG_FTAPBBRG020S_0_IRQ0 + APBBRG_FTAPBBRG020S_IRQ_COUNT;
             i++ )
        {
                // level trigger
                set_irq_chip(i, &intc_ftapbbrg020s_level_chip);
                set_irq_handler(i, do_level_IRQ);
                set_irq_flags(i, IRQF_VALID | IRQF_PROBE);
                set_irq_chipdata( i, (void*) PLATFORM_APBDMA_IRQ);
        }

        return 0;
}

arch_initcall( intc_ftapbbrg020s_init_irq );
#endif /* CONFIG_PLATFORM_APBDMA */
