/*
 *  linux/arch/armnommu/mach-faraday/platform-a320/fia321.c
 *
 *  FIA321 Platform Initialization
 *  
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * ChangeLog
 * 
 *  Luke Lee  09/15/2005  Created
 *  Peter Liao 09/28/2005 Add PCI support
 *  Peter Liao 10/03/2005 Add APB DMA support
 */

#include <linux/ioport.h>
#include <linux/delay.h>
#include <linux/pm.h>
#include <linux/init.h>

#include <asm/mach-types.h>
#include <asm/mach/arch.h>

#include <asm/sizes.h>
#include <asm/mach/map.h>
//#include <asm/mach/time.h>

#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <asm/io.h>
#include <asm/arch/ftpci.h>

/*
 * Platform dependent and independent specifications
 */
#include <asm/arch/spec.h>

#define ARCH_INIT_IRQ	a321_arch_init_irq
/*
 * INTC device driver for FIA321
 */
#define INTC_PLATFORM_NAME              fia321
#define INTC_TEMPLATE_INTC_ID           PLATFORM_FIA321_INTC_FTINTC010_ID
#define INTC_TEMPLATE_IRQ_BASE          PLATFORM_FIA321_IRQ_BASE
#define INTC_TEMPLATE_FIQ_BASE          PLATFORM_FIA321_FIQ_BASE
#define INTC_TEMPLATE_INTC_NAME         "A321 interrupt controller"
#define INTC_TEMPLATE_IRQ_TRIGGER_MODE  PLATFORM_FIA321_FIQ_TRIGGER_MODE 
#define INTC_TEMPLATE_FIQ_TRIGGER_MODE  PLATFORM_FIA321_IRQ_TRIGGER_MODE 
#define INTC_TEMPLATE_IRQ_TRIGGER_LEVEL PLATFORM_FIA321_FIQ_TRIGGER_LEVEL
#define INTC_TEMPLATE_FIQ_TRIGGER_LEVEL PLATFORM_FIA321_IRQ_TRIGGER_LEVEL
#define INTC_TEMPLATE_IRQ_COUNT         PLATFORM_FIA321_IRQ_TOTALCOUNT
#define INTC_TEMPLATE_FIQ_COUNT         PLATFORM_FIA321_FIQ_TOTALCOUNT
#define INTC_TEMPLATE_PARENT_IRQ	PLATFORM_FIA321_IRQ
#define INTC_TEMPLATE_PARENT_FIQ	PLATFORM_FIA321_FIQ


#include "../template_intc.h"

arch_initcall( fia321_intc_ftintc010_init_irq );

/*
 * FIA321 IRQ Dispatch function
 */

#ifdef CONFIG_PCI
asmlinkage unsigned fia321_pci_dispatch(unsigned irq)
{
	int irq_ret;
	irq_ret = ftpci_get_irq();
	if ( irq_ret >= 0 )
		return irq_ret + PLATFORM_FIA321_PCI_IRQ_BASE;
	else {
		printk(KERN_ERR "fia321_pci_dispatch Error:irq=%d,map to %d\n",irq, ftpci_get_irq() + PLATFORM_FIA321_PCI_IRQ_BASE);
		return PLATFORM_INTERRUPTS;
	}
}
#else
#define fia321_pci_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_APBDMA
#include <asm/arch/apb_dma.h>
extern int (*platform_apbdma_get_irq)(int base);
asmlinkage unsigned fia321_apbdma_dispatch(unsigned irq)
{
	int irq_ret;
	if ( platform_apbdma_get_irq == NULL ) {
		printk(KERN_ERR "Donot register apb dma get irq func. pointer\n");
		return PLATFORM_INTERRUPTS;
	}
	irq_ret = platform_apbdma_get_irq(APBBRG_FTAPBBRG020S_1_VA_BASE);
	if ( irq_ret >= 0 )
		return irq_ret + PLATFORM_FIA321_APBDMA_IRQ_BASE;
	else {
		printk(KERN_ERR "fia321_apbdma_dispatch Error:irq=%d,map to %d\n",irq, platform_apbdma_get_irq(APBBRG_FTAPBBRG020S_1_VA_BASE) + PLATFORM_FIA321_APBDMA_IRQ_BASE);
		return PLATFORM_INTERRUPTS;
	}
}
#else
#define fia321_apbdma_dispatch 0
#endif

asmlinkage unsigned fia321_invalid_irq(unsigned irq)
{
#define REPORT_LIMIT 255
        static unsigned report_count = 0;
        
        //assert(irq==32);
        //This should never happen. If this really happened, either kernel porting
        //error or some hardware glitch/failure occurs.
        if (report_count <= REPORT_LIMIT) {
                printk( KERN_ERR "FIA321 interrupt accidentally raised%s.\n",
                        (report_count==REPORT_LIMIT) ?
                        "" : " for over %d times, will cease reporting this error" );
                report_count++;
        }
                
        return PLATFORM_INTERRUPTS;
}

const interrupt_dispatch_function *fia321_irq_dispatch_table[33]
= {
        /* 00 */    0,
        /* 01 */    0,
        /* 02 */    0,
        /* 03 */    0,
        /* 04 */    0,
        /* 05 */    0,
        /* 06 */    0,
        /* 07 */    0,
        /* 08 */    0,
        /* 09 */    0,
        /* 10 */    0,
        /* 11 */    0,
        /* 12 */    0,
        /* 13 */    0,
        /* 14 */    0,
        /* 15 */    0,
        /* 16 */    0,
        /* 17 */    0,
        /* 18 */    0,
        /* 19 */    0,
        /* 20 */    0,
        /* 21 */    0,
        /* 22 */    0,
        /* 23 */    0,
        /* 24 */    fia321_apbdma_dispatch,
        /* 25 */    0,
        /* 26 */    0,
        /* 27 */    0,
        /* 28 */    fia321_pci_dispatch,
        /* 29 */    0,        
        /* 30 */    0,
        /* 31 */    0,
        /* 32 */    fia321_invalid_irq
};

asmlinkage unsigned fia321_irq30_dispatch(unsigned irq)
{
	unsigned irq_status;
        const interrupt_dispatch_function *dispatch_func;
        //assert( irq==30 );
        irq_status = *(volatile unsigned*)(IP_VA_BASE(PLATFORM_FIA321_INTC_FTINTC010_ID)+IRQ_STATUS_REG);
        irq = irq_status ? 31:32;
	if (irq_status & 0x0000ffff) { irq -= 16; irq_status <<= 16; }
	if (irq_status & 0x00ff0000) { irq -= 8;  irq_status <<= 8;  }
	if (irq_status & 0x0f000000) { irq -= 4;  irq_status <<= 4;  }
	if (irq_status & 0x30000000) { irq -= 2;  irq_status <<= 2;  }
	if (irq_status & 0x40000000) { irq -= 1; }
        dispatch_func = fia321_irq_dispatch_table[irq];
        if (dispatch_func)
                irq = dispatch_func(irq);
        else
                irq += PLATFORM_FIA321_IRQ_BASE;
        return irq;
}

