/*
 *  linux/arch/arm/mach-faraday/platform-kira100/spec.c
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2006 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    KIRA100
 *     +- CPU_FA526  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- TIMER_FTTMR010  (0)
 *     +- PMU_FTPMU010  (0)
 *     +- MAC_FTMAC100  (0)
 *     +- SDC_FTSDC010  (0)
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- APBDMA
 *         +- APBBRG_FTAPBBRG020S  (0)
 */


#include <linux/config.h>
#include <linux/init.h>
#include <linux/module.h>

#include <asm/mach/map.h>
#include <asm/sizes.h>

#include <asm/arch/platform/spec.h>

/*
 * Interrrupt numbers
 */


/* UART */
const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_IRQ,
//     UART_FTUART010_1_IRQ,
     UART_FTUART010_2_IRQ
};

/* TIMER */
const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_IRQ
};

/* MAC */
const unsigned char MAC_FTMAC100_irq[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_IRQ
};

/* SDC */
const unsigned char SDC_FTSDC010_irq[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_IRQ
};

/* DMAC */
const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT] = {
    { DMAC_FTDMAC020_0_IRQ0, DMAC_FTDMAC020_0_IRQ1, DMAC_FTDMAC020_0_IRQ2, DMAC_FTDMAC020_0_IRQ3, DMAC_FTDMAC020_0_IRQ4, DMAC_FTDMAC020_0_IRQ5, DMAC_FTDMAC020_0_IRQ6, DMAC_FTDMAC020_0_IRQ7 }
};

/* APBBRG */
const unsigned char APBBRG_FTAPBBRG020S_irq[APBBRG_FTAPBBRG020S_COUNT][APBBRG_FTAPBBRG020S_IRQ_COUNT] = {
    { APBBRG_FTAPBBRG020S_0_IRQ0, APBBRG_FTAPBBRG020S_0_IRQ1, APBBRG_FTAPBBRG020S_0_IRQ2, APBBRG_FTAPBBRG020S_0_IRQ3 }
};

/*
 * Base addresses
 */


/* CPU */
const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_BASE
};
const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_LIMIT
};
const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT] = {
     CPU_MEM_0_PA_SIZE
};

/* INTC */
const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_BASE
};
const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_LIMIT
};
const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_PA_SIZE
};
const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_BASE
};
const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_LIMIT
};
const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT] = {
     INTC_FTINTC010_0_VA_SIZE
};

/* UART */
const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_BASE,
//     UART_FTUART010_1_PA_BASE,
     UART_FTUART010_2_PA_BASE
};
const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_LIMIT,
//     UART_FTUART010_1_PA_LIMIT,
     UART_FTUART010_2_PA_LIMIT
};
const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_PA_SIZE,
//     UART_FTUART010_1_PA_SIZE,
     UART_FTUART010_2_PA_SIZE
};
const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_BASE,
//     UART_FTUART010_1_VA_BASE,
     UART_FTUART010_2_VA_BASE
};
const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_LIMIT,
//     UART_FTUART010_1_VA_LIMIT,
     UART_FTUART010_2_VA_LIMIT
};
const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT] = {
     UART_FTUART010_0_VA_SIZE,
//     UART_FTUART010_1_VA_SIZE,
     UART_FTUART010_2_VA_SIZE
};

/* TIMER */
const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_BASE
};
const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_LIMIT
};
const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_PA_SIZE
};
const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_BASE
};
const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_LIMIT
};
const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT] = {
     TIMER_FTTMR010_0_VA_SIZE
};

/* PMU */
const unsigned PMU_FTPMU010_pa_base[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_BASE
};
const unsigned PMU_FTPMU010_pa_limit[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_LIMIT
};
const unsigned PMU_FTPMU010_pa_size[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_PA_SIZE
};
const unsigned PMU_FTPMU010_va_base[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_BASE
};
const unsigned PMU_FTPMU010_va_limit[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_LIMIT
};
const unsigned PMU_FTPMU010_va_size[PMU_FTPMU010_COUNT] = {
     PMU_FTPMU010_0_VA_SIZE
};

/* MAC */
const unsigned MAC_FTMAC100_pa_base[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_PA_BASE
};
const unsigned MAC_FTMAC100_pa_limit[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_PA_LIMIT
};
const unsigned MAC_FTMAC100_pa_size[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_PA_SIZE
};
const unsigned MAC_FTMAC100_va_base[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_VA_BASE
};
const unsigned MAC_FTMAC100_va_limit[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_VA_LIMIT
};
const unsigned MAC_FTMAC100_va_size[MAC_FTMAC100_COUNT] = {
     MAC_FTMAC100_0_VA_SIZE
};

/* SDC */
const unsigned SDC_FTSDC010_pa_base[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_PA_BASE
};
const unsigned SDC_FTSDC010_pa_limit[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_PA_LIMIT
};
const unsigned SDC_FTSDC010_pa_size[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_PA_SIZE
};
const unsigned SDC_FTSDC010_va_base[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_VA_BASE
};
const unsigned SDC_FTSDC010_va_limit[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_VA_LIMIT
};
const unsigned SDC_FTSDC010_va_size[SDC_FTSDC010_COUNT] = {
     SDC_FTSDC010_0_VA_SIZE
};

/* DMAC */
const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_BASE
};
const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_LIMIT
};
const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_PA_SIZE
};
const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_BASE
};
const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_LIMIT
};
const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT] = {
     DMAC_FTDMAC020_0_VA_SIZE
};

/* APBBRG */
const unsigned APBBRG_FTAPBBRG020S_pa_base[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_BASE
};
const unsigned APBBRG_FTAPBBRG020S_pa_limit[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020S_pa_size[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_PA_SIZE
};
const unsigned APBBRG_FTAPBBRG020S_va_base[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_BASE
};
const unsigned APBBRG_FTAPBBRG020S_va_limit[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_LIMIT
};
const unsigned APBBRG_FTAPBBRG020S_va_size[APBBRG_FTAPBBRG020S_COUNT] = {
     APBBRG_FTAPBBRG020S_0_VA_SIZE
};

/*
 * Platform Initialization Information
 */

const struct map_desc platform_io_desc[] __initdata = {
    { INTC_FTINTC010_0_VA_BASE,		INTC_FTINTC010_0_PA_BASE,	0x00001000,	MT_DEVICE },
    { UART_FTUART010_0_VA_BASE,		UART_FTUART010_0_PA_BASE,	0x00001000,	MT_DEVICE },
//    { UART_FTUART010_1_VA_BASE,		UART_FTUART010_1_PA_BASE,	0x00001000,	MT_DEVICE },
    { UART_FTUART010_2_VA_BASE,		UART_FTUART010_2_PA_BASE,	0x00001000,	MT_DEVICE },
    { TIMER_FTTMR010_0_VA_BASE,		TIMER_FTTMR010_0_PA_BASE,	0x00001000,	MT_DEVICE },
    { PMU_FTPMU010_0_VA_BASE,		PMU_FTPMU010_0_PA_BASE,		0x00001000,	MT_DEVICE },
    { MAC_FTMAC100_0_VA_BASE,		MAC_FTMAC100_0_PA_BASE,		0x00001000,	MT_DEVICE },
    { SDC_FTSDC010_0_VA_BASE,		SDC_FTSDC010_0_PA_BASE,		0x00001000,	MT_DEVICE },
    { DMAC_FTDMAC020_0_VA_BASE,		DMAC_FTDMAC020_0_PA_BASE,	0x00001000,	MT_DEVICE },
    { APBBRG_FTAPBBRG020S_0_VA_BASE,	APBBRG_FTAPBBRG020S_0_PA_BASE,	0x00001000,	MT_DEVICE },
    /* additional mappings, not generated by autospec */
    { CPE_WDT_VA_BASE,		CPE_WDT_BASE,		0x00001000,	MT_DEVICE },
    { CPE_RTC_VA_BASE,		CPE_RTC_BASE,		0x00001000,	MT_DEVICE },
    { CPE_FTMAC2_VA_BASE,	CPE_FTMAC2_BASE,	0x00001000,	MT_DEVICE },
    { CPE_GPIO_VA_BASE,		CPE_GPIO_BASE,		0x00001000,	MT_DEVICE },
    { CPE_AHBDMA_VA_BASE,	CPE_AHBDMA_BASE,	0x00001000,	MT_DEVICE },
    { CPE_AHB_VA_BASE,		CPE_AHB_BASE,		0x00001000,	MT_DEVICE },
    { CPE_USBDEV_VA_BASE,	CPE_USBDEV_BASE,	0x00001000,	MT_DEVICE },
    { CPE_APBDMA_VA_BASE,	CPE_APBDMA_BASE,	0x00001000,	MT_DEVICE },
    { CPE_AES_VA_BASE,		CPE_AES_BASE,		0x00001000,	MT_DEVICE },
    { CPE_PWM_VA_BASE,		CPE_PWM_BASE,		0x00001000,	MT_DEVICE },
    { CPE_I2C1_VA_BASE,		CPE_I2C1_BASE,		0x00001000,	MT_DEVICE },
    { CPE_I2C2_VA_BASE,		CPE_I2C2_BASE,		0x00001000,	MT_DEVICE },
    { CPE_I2C3_VA_BASE,		CPE_I2C3_BASE,		0x00001000,	MT_DEVICE },
    { CPE_I2C4_VA_BASE,		CPE_I2C4_BASE,		0x00001000,	MT_DEVICE },
    { CPE_I2C5_VA_BASE,		CPE_I2C5_BASE,		0x00001000,	MT_DEVICE },
    { CPE_SSP_VA_BASE,		CPE_SSP_BASE,		0x00001000,	MT_DEVICE },
    { CPE_LPC_VA_BASE,		CPE_LPC_BASE,		0x00001000,	MT_DEVICE },
    { CPE_FML_VA_BASE,		CPE_FML_BASE,		0x00001000,	MT_DEVICE },
    { CPE_VSC_VA_BASE,		CPE_VSC_BASE,		0x00001000,	MT_DEVICE },
    /* old mappings taken from faraday linux 2.4 but also available autospec'ed above
    { CPE_PMU_VA_BASE,		CPE_PMU_BASE,		0x00001000,	MT_DEVICE_NCB },
    { CPE_UART1_VA_BASE,	CPE_UART1_BASE,		0x00001000,	MT_DEVICE_NCB },
    { CPE_UART1_VA_BASE,	CPE_UART1_BASE,		0x00001000,	MT_DEVICE_NCB },
    { CPE_UART3_VA_BASE,	CPE_UART3_BASE,		0x00001000,	MT_DEVICE_NCB },
    { CPE_TIMER_VA_BASE,	CPE_TIMER_BASE,		0x00001000,	MT_DEVICE_NCB },
    { CPE_IC_VA_BASE,		CPE_IC_BASE,		0x00001000,	MT_DEVICE_NCB },
    */
};

void
platform_io_desc_get(struct map_desc **desc, int *size)
{
    if (!desc || !size) {
	BUG();
    }

    *desc = platform_io_desc;
    *size = ARRAY_SIZE(platform_io_desc);
}

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

/* const interrupt_dispatch_function *fiq_dispatch_table[32]; */

#ifdef IRQ_DISPATCH_TABLE
const interrupt_dispatch_function *irq_dispatch_table[32]
= {
    /* 00 */  0,
    /* 01 */  0,
    /* 02 */  0,
    /* 03 */  0,
    /* 04 */  0,
    /* 05 */  0,
    /* 06 */  0,
    /* 07 */  0,
    /* 08 */  0,
    /* 09 */  0,
    /* 10 */  0,
    /* 11 */  0,
    /* 12 */  0,
    /* 13 */  0,
    /* 14 */  0,
    /* 15 */  0,
    /* 16 */  0,
    /* 17 */  0,
    /* 18 */  0,
    /* 19 */  0,
    /* 20 */  0,
    /* 21 */  ahbdma_irq21_dispatch,
    /* 22 */  0,
    /* 23 */  0,
    /* 24 */  apbdma_irq24_dispatch,
    /* 25 */  0,
    /* 26 */  0,
    /* 27 */  0,
    /* 28 */  0,
    /* 29 */  0,
    /* 30 */  0,
    /* 31 */  0
};
#endif


/*
 * Export All Symbols
 */

/*
 * Interrrupt numbers
 */

/* UART */
EXPORT_SYMBOL( UART_FTUART010_irq );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_irq );
/* MAC */
EXPORT_SYMBOL( MAC_FTMAC100_irq );
/* SDC */
EXPORT_SYMBOL( SDC_FTSDC010_irq );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_irq );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_irq );

/*
 * Base addresses
 */

/* CPU */
EXPORT_SYMBOL( CPU_MEM_pa_base );
EXPORT_SYMBOL( CPU_MEM_pa_limit );
EXPORT_SYMBOL( CPU_MEM_pa_size );
/* INTC */
EXPORT_SYMBOL( INTC_FTINTC010_pa_base );
EXPORT_SYMBOL( INTC_FTINTC010_pa_limit );
EXPORT_SYMBOL( INTC_FTINTC010_pa_size );
EXPORT_SYMBOL( INTC_FTINTC010_va_base );
EXPORT_SYMBOL( INTC_FTINTC010_va_limit );
EXPORT_SYMBOL( INTC_FTINTC010_va_size );
/* UART */
EXPORT_SYMBOL( UART_FTUART010_pa_base );
EXPORT_SYMBOL( UART_FTUART010_pa_limit );
EXPORT_SYMBOL( UART_FTUART010_pa_size );
EXPORT_SYMBOL( UART_FTUART010_va_base );
EXPORT_SYMBOL( UART_FTUART010_va_limit );
EXPORT_SYMBOL( UART_FTUART010_va_size );
/* TIMER */
EXPORT_SYMBOL( TIMER_FTTMR010_pa_base );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_pa_size );
EXPORT_SYMBOL( TIMER_FTTMR010_va_base );
EXPORT_SYMBOL( TIMER_FTTMR010_va_limit );
EXPORT_SYMBOL( TIMER_FTTMR010_va_size );
/* PMU */
EXPORT_SYMBOL( PMU_FTPMU010_pa_base );
EXPORT_SYMBOL( PMU_FTPMU010_pa_limit );
EXPORT_SYMBOL( PMU_FTPMU010_pa_size );
EXPORT_SYMBOL( PMU_FTPMU010_va_base );
EXPORT_SYMBOL( PMU_FTPMU010_va_limit );
EXPORT_SYMBOL( PMU_FTPMU010_va_size );
/* MAC */
EXPORT_SYMBOL( MAC_FTMAC100_pa_base );
EXPORT_SYMBOL( MAC_FTMAC100_pa_limit );
EXPORT_SYMBOL( MAC_FTMAC100_pa_size );
EXPORT_SYMBOL( MAC_FTMAC100_va_base );
EXPORT_SYMBOL( MAC_FTMAC100_va_limit );
EXPORT_SYMBOL( MAC_FTMAC100_va_size );
/* SDC */
EXPORT_SYMBOL( SDC_FTSDC010_pa_base );
EXPORT_SYMBOL( SDC_FTSDC010_pa_limit );
EXPORT_SYMBOL( SDC_FTSDC010_pa_size );
EXPORT_SYMBOL( SDC_FTSDC010_va_base );
EXPORT_SYMBOL( SDC_FTSDC010_va_limit );
EXPORT_SYMBOL( SDC_FTSDC010_va_size );
/* DMAC */
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_pa_size );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_base );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_limit );
EXPORT_SYMBOL( DMAC_FTDMAC020_va_size );
/* APBBRG */
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_pa_size );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_base );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_limit );
EXPORT_SYMBOL( APBBRG_FTAPBBRG020S_va_size );

/*
 * Interrupt Dispatch Tables, for both FIQ and IRQ
 */

#ifdef IRQ_DISPATCH_TABLE
EXPORT_SYMBOL( irq_dispatch_table );
#endif

