/*
 * FILE NAME: ppc405_pcimcs.h
 *
 * BRIEF MODULE DESCRIPTION:
 * machine check save pci access and configuration routines.
 * These routines may also be used in case a certain PCI
 * resource is physically not present. The according functions
 * will return an error code.
 *
 * Author: Peppercon AG
 *         Thomas Breitfeld <thomas@peppercon.de>
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef __KERNEL__
#ifndef __ASMPPC_405_PCIMCS_H
#define __ASMPPC_405_PCIMCS_H

#include <linux/types.h>
#include <linux/pci.h>
#include <asm/io.h>
#include <asm/system.h>
#include <asm/ibm4xx.h>

/*
 * machine check save I/O routines,
 * an occured machine check will be signaled to the caller
 * by setting the error flag to true
 */
u8 mcs_in_8(volatile u8 * addr, int * error);
u16 mcs_in_le16(volatile u16 * addr, int * error);
u32 mcs_in_le32(volatile u32 * addr, int * error);
void mcs_out_8(u32 data, volatile u8 * addr, int * error);
void mcs_out_le16(u32 data, volatile u16 * addr, int * error);
void mcs_out_le32(u32 data, volatile u32 * addr, int * error);

int mcs_pci_read_config_byte(struct pci_dev *dev, int offset, u8* value);
int mcs_pci_read_config_word(struct pci_dev *dev, int offset, u16* value);
int mcs_pci_read_config_dword(struct pci_dev *dev, int offset, u32* value);
#define mcs_pci_read_config_long mcs_pci_read_config_dword
int mcs_pci_write_config_byte(struct pci_dev *dev, int offset, u8 value);
int mcs_pci_write_config_word(struct pci_dev *dev, int offset, u16 value);
int mcs_pci_write_config_dword(struct pci_dev *dev, int offset, u32 value);
#define mcs_pci_write_config_long mcs_pci_write_config_dword

void fix_pci_read_config_byte(u32 cfg_addr, u32 cfg_date, int off, u8* v);
void fix_pci_read_config_word(u32 cfg_addr, u32 cfg_date, int off, u16* v);
void fix_pci_read_config_dword(u32 cfg_addr, u32 cfg_date, int off, u32* v);
#define fix_pci_read_config_long fix_pci_read_config_dword
void fix_pci_write_config_byte(u32 cfg_addr, u32 cfg_date, int off, u8 v);
void fix_pci_write_config_word(u32 cfg_addr, u32 cfg_date, int off, u16 v);
void fix_pci_write_config_dword(u32 cfg_addr, u32 cfg_date, int off, u32 v);
#define fix_pci_write_config_long fix_pci_write_config_dword

#endif /* __ASMPPC_405_PCIMCS_H */
#endif /* __KERNEL__ */
