/*
** I2C interface
** =============
** (C) 2000 by Paolo Scaffardi (arsenio@tin.it)
** AIRVENT SAM s.p.a - RIMINI(ITALY)
**
*/

#ifndef	__PPC4XX_I2C_H__
#define	__PPC4XX_I2C_H__

#include <linux/config.h>

#define CONFIG_I2C_X                    /* 16 bit access */
#define CONFIG_RTC_X1240        1	/* we have a Xicor X1240 RTC */
#define CFG_I2C_RTC_ADDR	0x6F    /*				  and one for RTC */
#define CFG_I2C_EEPROM_ADDR     0x57	/* X1240 has two I2C slave addresses, one for EEPROM */

#define X1240_SC			0x30
#define X1240_MIN			0x31
#define X1240_HR			0x32
#define X1240_DT			0x33
#define X1240_MO			0x34
#define X1240_YR			0x35
#define X1240_DW			0x36
#define X1240_Y2K			0x37

#define X1240_CONTROL			0x10
#define X1240_STATUS			0x3F

#define X1240_HR_MIL			0x80
#define X1240_STATUS_BATTERY_FLAG  	0x20 /* not documented */
#define X1240_STATUS_RWEL		0x04
#define X1240_STATUS_WEL		0x02
#define X1240_STATUS_RTCF		0x01


#define IIC_OK		0
#define IIC_NOK		1
#define IIC_NOK_LA	2 /* Lost arbitration */
#define IIC_NOK_ICT	3 /* Incomplete transfer */
#define IIC_NOK_XFRA	4 /* Transfer aborted */
#define IIC_NOK_DATA	5 /* No data in buffer */
#define IIC_NOK_TOUT	6 /* Transfer timeout */

#define IIC_TIMEOUT 1 /* 1 seconde */

/* Registers */
#define IICMDBUF	0x0
#define IICSDBUF	0x2
#define IICLMADR	0x4
#define IICHMADR	0x5
#define IICCNTL		0x6
#define IICMDCNTL	0x7
#define IICSTS		0x8
#define IICEXTSTS	0x9
#define IICLSADR	0xa
#define IICHSADR	0xb
#define IICCLKDIV	0xc
#define IICINTRMSK	0xd
#define IICXFRCNT	0xe
#define IICXTCNTLSS	0xf
#define IICDIRECTCNTL	0x10

#define	   I2C_REGISTERS_BASE_ADDRESS 0xEF600500
#define    IIC_MDBUF	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICMDBUF))
#define    IIC_SDBUF	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICSDBUF))
#define    IIC_LMADR	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICLMADR))
#define    IIC_HMADR	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICHMADR))
#define    IIC_CNTL	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICCNTL))
#define    IIC_MDCNTL	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICMDCNTL))
#define    IIC_STS	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICSTS))
#define    IIC_EXTSTS	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICEXTSTS))
#define    IIC_LSADR	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICLSADR))
#define    IIC_HSADR	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICHSADR))
#define    IIC_CLKDIV	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICCLKDIV))
#define    IIC_INTRMSK	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICINTRMSK))
#define    IIC_XFRCNT	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICXFRCNT))
#define    IIC_XTCNTLSS	((void *)(I2C_REGISTERS_BASE_ADDRESS+IICXTCNTLSS))
#define    IIC_DIRECTCNTL ((void *)(I2C_REGISTERS_BASE_ADDRESS+IICDIRECTCNTL))

/* MDCNTL Register Bit definition */
#define    IIC_MDCNTL_HSCL 0x01
#define    IIC_MDCNTL_EUBS 0x02
#define    IIC_MDCNTL_FMDB 0x40
#define    IIC_MDCNTL_FSDB 0x80

/* CNTL Register Bit definition */
#define    IIC_CNTL_PT     0x01
#define    IIC_CNTL_READ   0x02
#define    IIC_CNTL_CHT    0x04

/* STS Register Bit definition */
#define    IIC_STS_PT	   0x01
#define    IIC_STS_ERR	   0x04
#define    IIC_STS_MDBS    0x20

/* EXTSTS Register Bit definition */
#define    IIC_EXTSTS_XFRA 0x01
#define    IIC_EXTSTS_ICT  0x02
#define    IIC_EXTSTS_LA   0x04


#if 0
int  i2c_receive(unsigned char address,
		 unsigned short size_to_expect, unsigned char datain[] );
int  i2c_send(unsigned char address,
		 unsigned short size_to_send, unsigned char dataout[] );
void  i2c_read  (unsigned char *addr, int alen, unsigned char *buffer, int len);
void  i2c_write (unsigned char *addr, int alen, unsigned char *buffer, int len);
#endif
void i2c_init(void);
int rtc_read  (unsigned offset, unsigned char *buffer, unsigned cnt);
int rtc_write (unsigned offset, unsigned char *buffer, unsigned cnt);


#define ERROR_I2C_NONE		0
#define ERROR_I2C_LENGTH	1

#define I2C_WRITE_BIT		0x00
#define I2C_READ_BIT		0x01

#endif	/* __PPC4XX_I2C_H__ */
