/*
 *
 *    Copyright (c) 2004 Fujitsu Limited
 *
 *    Module name: ppc4xx_wdt.h
 *    Author:      Takeharu KATO<kato.takeharu@jp.fujitsu.com>
 *    Description:
 *      Header file for PPC4xx watchdog driver.
 *
 *    This program is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU General Public License
 *    as published by the Free Software Foundation; either version 2
 *    of the License, or (at your option) any later version.
 *
 *    Neither Takeharu KATO nor Fujitsu Ltd. admit liability nor provide
 *    warranty for any of this software.
 *
 */
#ifndef _DRIVERS_CHAR_WATCHDOG_PPC4XX_WDT_H
#define _DRIVERS_CHAR_WATCHDOG_PPC4XX_WDT_H
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/ptrace.h>
#include <linux/watchdog.h>

/*
 *  Driver state flags(bit position)
 */
#define WDT_STATE_OPEN                  0   /* driver is opend  */
#define WDT_STATE_STOP_ON_CLOSE         1   /* Stop with close is expected */
/*
 * Configurations
 */
#define WDT_TIMO           60000	/* Default timeout = 60000 ms(1min) */
#define WDT_HEARTBEAT_MIN  100          /* Minimum timeout = 100 ms */
#define WDT_HEARTBEAT_MAX  600000       /* Maximum timeout = 600000ms(1hour) */
#ifdef __KERNEL__
//#define WDT_DEBUG                     /*  Debug switch */
/*
 *  Reset type
 */
#define WDT_RESET_NONE     0
#define WDT_RESET_CORE     1
#define WDT_RESET_CHIP     2
#define WDT_RESET_SYS      3
/*
 *   Bit positions in  TCR register on PPC4xx/e500 series.
 */
#define WDT_TCR_WP_BIT     1   /*  WP  bit in TCR (bit[0..1])   */
#define WDT_TCR_WRC_BIT    3   /*  WRC bit in TCR (bit[2..3])   */
#define WDT_TCR_WIE_BIT    4   /*  WIE bit in TCR (bit[4])      */
/*
 *  TCR[WP] relevant definitions
 */
#define WDT_TCR_WP_SHIFT       (31 - WDT_TCR_WP_BIT)
#define WDT_TCR_WRC_SHIFT      (31 - WDT_TCR_WRC_BIT)
#define WDT_TCR_WIE_SHIFT      (31 - WDT_TCR_WIE_BIT)
#define WDT_TCR_WDT_ENABLE     (1<<WDT_TCR_WIE_SHIFT)
/*  MASK value to obatain TCR[WP]  */
#define WDT_TCR_WP_MASK        (3<<(WDT_TCR_WP_SHIFT))

/*  Watchdog timer periods can be set on PPC4xx cpus. */
#if defined(CONFIG_4xx)
/*
 *  For PowerPC4xx
 */
#define WDT_WP0               0
#define WDT_WP1               1
#define WDT_WP2               2
#define WDT_WP3               3
#else
#if defined(CONFIG_E500)
/*
 *  For e500 CPU
 *  Actually, e500 can arbitrary periods can be set,
 *  But this driver uses fix period value as same as PPC440
 *  on purpose for simplicity.
 *  Following values split into WP and WP_EXT parts in ppc4xx_wdt.c.
 */
#define WDT_WP0               21
#define WDT_WP1               25
#define WDT_WP2               29
#define WDT_WP3               33
#define WDT_TCR_WP_BITMSK     0x3  /*  2bit length  */
#define WDT_TCR_WPEXT_BITMSK  0xf  /*  4bit length  */
#define WDT_TCR_WPEXT_SHIFT  17
#else
#error "PPC4xx WDT Detect invalid configuration(Unknown CPU)"
#endif  /*  CONFIG_E500  */
#endif  /*  CONFIG_4xx   */
/*
 *  WP relevant values used in our driver.
 *  Note:WDT period must be more than HZ(Timer ticks)
 */
#define WDT_WP                 WDT_WP3

/*
 *  IOCTL commands for comaptiblity for old driver
 */
#define WDIOC_GETPERIOD         WDIOC_GETTIMEOUT
#define WDIOC_SETPERIOD         WDIOC_SETTIMEOUT

/*
 *  output messages
 */
#define __PPC4xx_WDT_MSG "PPC4xx WDT : "
#define ppc4xx_mkmsg(str) __PPC4xx_WDT_MSG str
#define ppc4xx_wdt_info(fmt,arg...) \
	printk(KERN_INFO __PPC4xx_WDT_MSG fmt,##arg)
#define ppc4xx_wdt_note(fmt,arg...) \
	printk(KERN_NOTICE __PPC4xx_WDT_MSG fmt,##arg)
#define ppc4xx_wdt_err(fmt,arg...) \
	printk(KERN_ALERT __PPC4xx_WDT_MSG fmt,##arg)
#define ppc4xx_wdt_crit(fmt,arg...) \
	printk(KERN_ALERT __PPC4xx_WDT_MSG fmt,##arg)
#if defined(WDT_DEBUG)
#define ppc4xx_wdt_dbg(fmt,arg...) \
	printk(KERN_ALERT __PPC4xx_WDT_MSG fmt,##arg)
#else
#define ppc4xx_wdt_dbg(fmt,arg...) \
        do{}while(0)
#endif  /*  WDT_DEBUG  */

#endif  /* __KERNEL__  */
#endif  /*  _DRIVERS_CHAR_WATCHDOG_PPC4XX_WDT_H  */
