/*
 *  linux/include/asm-arm/arch-faraday/entry-macro.S
 *
 *  Faraday Low-level Interrupt Vector Interface Macros
 *  
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *  
 * ChangeLog
 *
 *  Luke Lee  08/30/2005  Created. Optimized for interrupt latency.
 *  Luke Lee  09/28/2005  Bug fixed for dispatch function.
 */

#include <asm/arch/spec.h>
#include <asm/arch/intc.h>

		.macro	disable_fiq
		.endm	

		/*
		 * An O(1) optimized version for getting IRQ/FIQ number
		 * 08/29/2005 Luke Lee
		 * Input/output: irqnr (initial value), irqstat (the word to scan)
		 * Local R/W:	 tmp
		 */
		.macro __get_int_nr_and_base, irqnr, irqstat, tmp
		mov	\tmp, \irqstat, lsl #16	     /* check if lower 16 bits = zero */
	        cmp	\tmp, #0
	        movne   \irqstat, \irqstat, lsl #16  /* irqstat <<= 16 */
	        subne   \irqnr, \irqnr, #16	     /* irqnr -= 16 */
	        tst     \irqstat, #0x00FF0000
	        movne   \irqstat, \irqstat, lsl #8   /* irqstat <<= 8 */
	        subne   \irqnr, \irqnr, #8	     /* irqnr -= 8 */
	        tst     \irqstat, #0x0F000000
	        movne   \irqstat, \irqstat, lsl #4   /* irqstat <<= 4 */
	        subne   \irqnr, \irqnr, #4	     /* irqnr -= 4 */
	        tst     \irqstat, #0x30000000
	        movne   \irqstat, \irqstat, lsl #2   /* irqstat <<= 2 */
	        subne   \irqnr, \irqnr, #2	     /* irqnr -= 2 */
	        tst     \irqstat, #0x40000000
	        subne   \irqnr, \irqnr, #1	     /* irqnr -= 1 */
		.endm

.extern vfunc,vbase,vindex,virqnr
	
		/*
		 * Fixup IRQ/FIQ number if dispatch table defined.
		 * 08/29/2005 Luke Lee
		 * Input/output: irqnr
		 * local R/W:	 base
		 * local R/O:	 index (it's R/O, thus can be applied by irqnr)
		 * constant:	 table name
		 */
		.macro __fixup_int_dispatch, irqnr, base, index, table
		.ifeqs	"r0","\base"
		.error  "In macro __fixup_irq_dispatch : argument 'base' cannot be R0."
		.endif
		.ifeqs	"R0","\base"
		.error  "In macro __fixup_irq_dispatch : argument 'base' cannot be R0."
		.endif
		ldr	\base, =\table
		ldr	\base, [\base, +\index, lsl #2]
		cmp	\base, #0
		.ifnes	"r0","\irqnr"
		.ifnes	"R0","\irqnr"
		mov	r0, \irqnr
		.endif  /* "R0" */
		.endif	/* "r0" */
		/*
		 * Call dispatch routine
		 */
		movne	lr, pc
                movne	pc, \base
		.ifnes	"r0","\irqnr"
		.ifnes	"R0","\irqnr"
                mov     \irqnr, r0
		.endif  /* "R0" */
		.endif	/* "r0" */
		.endm
	

		/*
		 * Get FIQ number and base
		 * Input: none
		 * Output: irqnr, Z flag
		 * Local R/W: irqstat, base, tmp
		 */
		.macro get_fiqnr_and_base, irqnr, irqstat, base, tmp
		ldr	\base, =(INTC_FTINTC010_VA_BASE+FIQ_STATUS_REG)
		ldr 	\irqstat, [\base]
		cmp	\irqstat, #0
		beq	2001f
	        mov	\irqnr, #63
		
		__get_int_nr_and_base	\irqnr, \irqstat, \base

		#ifdef FIQ_DISPATCH_TABLE
		sub	\irqstat, \irqnr, #32	/* compute table index */
		__fixup_int_dispatch	\irqnr, \base, \irqstat, fiq_dispatch_table
		#endif

		cmp	\irqnr, #NR_IRQS
2001:		
		.endm	/* get_fiqnr_and_base */

		/*
		 * Get IRQ number and base
		 * Input: none
		 * Output: irqnr, Z flag
		 * Local R/W: irqstat, base, tmp
		 */
		.macro get_irqnr_and_base, irqnr, irqstat, base, tmp
		ldr	\base, =(INTC_FTINTC010_VA_BASE+IRQ_STATUS_REG)
		ldr	\irqstat, [\base]
		cmp	\irqstat, #0
		beq	2001f
	        mov	\irqnr, #31

		__get_int_nr_and_base	\irqnr, \irqstat, \base

		#ifdef IRQ_DISPATCH_TABLE
		__fixup_int_dispatch	\irqnr, \base, \irqnr, irq_dispatch_table
		#endif
	
		cmp	\irqnr, #NR_IRQS
2001:		
		.endm	/* get_irqnr_and_base */


		.macro irq_prio_table
		.endm	

