/*
 *  linux/include/asm-arm/arch-faraday/intc.h
 *
 *  Faraday FTINTC010 Interrupt Controller Device Driver Interface
 *
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ChangeLog
 * 
 *  Luke Lee  09/14/2005  Created, heavily modified from Faraday CPE platform code.
 */

#ifndef __FARADAY_INTC_FTINTC010_HEADER__
#define __FARADAY_INTC_FTINTC010_HEADER__

#include <linux/init.h>

#define IRQ_SOURCE_REG                  0
#define IRQ_MASK_REG                    0x04
#define IRQ_CLEAR_REG                   0x08
#define IRQ_MODE_REG                    0x0c
#define IRQ_LEVEL_REG                   0x10
#define IRQ_STATUS_REG                  0x14

#define FIQ_SOURCE_REG                  0x20
#define FIQ_MASK_REG                    0x24
#define FIQ_CLEAR_REG                   0x28
#define FIQ_MODE_REG                    0x2c
#define FIQ_LEVEL_REG                   0x30
#define FIQ_STATUS_REG                  0x34

#ifndef __ASSEMBLER__

extern void __init intc_ftintc010_init_irq(void);

#endif /* __ASSEMBLER__ */

#endif /* __FARADAY_INTC_FTINTC010_HEADER__ */
