#ifndef __CPE_BD
#define __CPE_BD

#define CONFIG_NR_DRAM_BANKS 1 /* on KIRA */

typedef struct {
    unsigned long   bi_flashstart;  /* start of FLASH memory */
    unsigned long   bi_flashsize;   /* size  of FLASH memory */
    unsigned long   bi_flashoffset; /* reserved area for startup monitor */
} bd_flash_info_t;

typedef struct {
        unsigned int    bi_def_jumper_set; /* defaults jumper/command state */
        unsigned int    bi_power_cim;   /* 1 if power cim was found at uart0 */
        unsigned int    bi_config_mode; /* 1 if config cmd used for bootup */
        unsigned int    bi_debug_mode;  /* 1 if config cmd used for bootup */
        unsigned char   bi_hwid;        /* hardware id of the board */
} bd_pp_info_t;

typedef struct {
        int             bi_hclk;        /* abh clock */
        int             bi_cpuclkdiv;   /* cpu clock div */
} bd_arm_clock_info_t;

typedef struct {
    unsigned char       bi_enetaddr[6]; /* Ethernet adress */
} bd_net_info_t;

typedef struct board_info {
    int                 bi_baudrate;    /* serial console baudrate */
    unsigned long       bi_ip_addr;     /* IP Address */
    struct environment_s               *bi_env;
    ulong               bi_arch_number; /* unique id for this board */
    ulong               bi_boot_params; /* where this board expects params */
    struct                             /* RAM configuration */
    {
        ulong start;
        ulong size;
    }               bi_dram[CONFIG_NR_DRAM_BANKS];
	
    bd_flash_info_t flash_info;
    bd_pp_info_t pp_info;
    bd_arm_clock_info_t clock_info;
    bd_net_info_t net_info;
} bd_arm_t;

extern unsigned char __res[];

#endif /* __CPE_BD */

