/*
 *  linux/include/asm-arm/arch-faraday/uncompress.h
 *
 *  Faraday Linux Boot Loader UART (FTUART010) Routines
 *
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Note
 *
 *  The first UART (FTUART010) in the system is used for dumping debug messages.
 * 
 * ChangeLog
 *
 *  Luke Lee  09/21/2005  Created. Heavily modified from Faraday CPE port.
 */

#include <asm/arch/spec.h>

#define IPMODULE UART
#define IPNAME   FTUART010


#define arch_decomp_setup()
#define arch_decomp_wdog()

#ifndef STANDALONE_DEBUG
#define putstr debug_puts
#endif

#define SERIAL_THR                     	0x00
#define SERIAL_LSR                      0x14
#define SERIAL_LSR_THRE                 0x20

static void debug_puts(const char *s)
{
        volatile unsigned *status = (volatile unsigned *)(IP_PA_BASE(0)+SERIAL_LSR);
	while (*s) {
                while ((*status & SERIAL_LSR_THRE)==0);

		*(volatile unsigned*)(IP_PA_BASE(0)+SERIAL_THR) = (unsigned)*s;
                
		if (*s == '\n') {
                        while ((*status & SERIAL_LSR_THRE)==0);
                        *(volatile unsigned*)(IP_PA_BASE(0)+SERIAL_THR) = '\r';
		}
		s++;
	}
}
