#include <linux/module.h>
#include <linux/skbuff.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <net/ip.h>
#include <net/checksum.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter_ipv4/ipt_FASTNAT.h>
#include <linux/netdevice.h>
#include <linux/route.h>
struct in_device;
#include <net/route.h>

#if 0
#define DEBUGP printk
#else
#define DEBUGP(format, args...)
#endif

/* (this is stolen from ip_nat_core.c)
 * We do checksum mangling, so if they were wrong before they're still
 * wrong.  Also works for incomplete packets (eg. ICMP dest
 * unreachables.) */
static u_int16_t
cheat_check(u_int32_t oldvalinv, u_int32_t newval, u_int16_t oldcheck)
{
        u_int32_t diffs[] = { oldvalinv, newval };
        return csum_fold(csum_partial((char *)diffs, sizeof(diffs),
                                      oldcheck^0xFFFF));
}


static unsigned int ipt_fastnat_target(struct sk_buff **pskb,
				       const struct net_device *in,
				       const struct net_device *out,
				       unsigned int hooknum,
				       const void *targinfo,
				       void *userinfo)
{
	const struct ipt_fastnat_info *fi = targinfo;
	struct iphdr *iph = (*pskb)->nh.iph;
	struct udphdr *udphdr;
	struct tcphdr *tcphdr;

	/* Rewrite IP header */
	(*pskb)->nfcache |= NFC_ALTERED;
	switch (iph->protocol) {
	  case IPPROTO_UDP:
	      udphdr = (struct udphdr *)((u_int32_t *)iph + iph->ihl);
	      if (fi->type & IPT_FASTNAT_SRC_ADDR) {
		  udphdr->check = cheat_check(~iph->saddr, fi->saddr.s_addr,
					      udphdr->check);
	      }
	      if (fi->type & IPT_FASTNAT_SRC_PORT) {
		  udphdr->check = cheat_check(~udphdr->source, fi->sport,
					      udphdr->check);
		  udphdr->source = fi->sport;
	      }
	      if (fi->type & IPT_FASTNAT_DST_ADDR) {
		  udphdr->check = cheat_check(~iph->daddr, fi->daddr.s_addr,
					      udphdr->check);
	      }
	      if (fi->type & IPT_FASTNAT_DST_PORT) {
		  udphdr->check = cheat_check(~udphdr->dest, fi->dport,
					      udphdr->check);
		  udphdr->dest = fi->dport;
	      }
	      break;
	  case IPPROTO_TCP:
	      tcphdr = (struct tcphdr *)((u_int32_t *)iph + iph->ihl);
	      if (fi->type & IPT_FASTNAT_SRC_ADDR) {
		  tcphdr->check = cheat_check(~iph->saddr, fi->saddr.s_addr,
					      tcphdr->check);
	      }
	      if (fi->type & IPT_FASTNAT_SRC_PORT) {
		  tcphdr->check = cheat_check(~tcphdr->source, fi->sport,
					      tcphdr->check);
		  tcphdr->source = fi->sport;
	      }
	      if (fi->type & IPT_FASTNAT_DST_ADDR) {
		  tcphdr->check = cheat_check(~iph->daddr, fi->daddr.s_addr,
					      tcphdr->check);
	      }
	      if (fi->type & IPT_FASTNAT_DST_PORT) {
		  tcphdr->check = cheat_check(~tcphdr->dest, fi->dport,
					      tcphdr->check);
		  tcphdr->dest = fi->dport;
	      }
	}

	if (fi->type & IPT_FASTNAT_SRC_ADDR) {
	    iph->check = cheat_check(~iph->saddr, fi->saddr.s_addr,iph->check);
	    DEBUGP("FASTNAT: src to %u.%u.%u.%u\n", NIPQUAD(fi->saddr.s_addr));
	    iph->saddr = fi->saddr.s_addr;
	}
	if (fi->type & IPT_FASTNAT_DST_ADDR) {
	    iph->check = cheat_check(~iph->daddr, fi->daddr.s_addr,iph->check);
	    DEBUGP("FASTNAT: dst to %u.%u.%u.%u\n", NIPQUAD(fi->daddr.s_addr));
	    iph->daddr = fi->daddr.s_addr;
	}

	return IPT_CONTINUE;
}

static int ipt_fastnat_checkentry(const char *tablename,
				  const struct ipt_entry *e,
				  void *targinfo,
				  unsigned int targinfosize,
				  unsigned int hook_mask)
{
	if (hook_mask & ~((1 << NF_IP_LOCAL_IN)
			  | (1 << NF_IP_PRE_ROUTING)
			  | (1 << NF_IP_LOCAL_OUT)
			  | (1 << NF_IP_POST_ROUTING))) {
		DEBUGP("FASTNAT: bad hook\n");
		return 0;
	}

	return 1;
}

static struct ipt_target ipt_fastnat_reg = {
	.name		= "FASTNAT",
	.target		= ipt_fastnat_target,
	.checkentry	= ipt_fastnat_checkentry,
	.me		= THIS_MODULE,
	.revision	= 0,
};	

static int __init init(void)
{
	return ipt_register_target(&ipt_fastnat_reg);
}

static void __exit fini(void)
{
	ipt_unregister_target(&ipt_fastnat_reg);
}

module_init(init);
module_exit(fini);
