#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "bmp.h"
#include "ccr.h"

unsigned long ccr = 0;

#define MAXHEIGHT 1200
#define MAXWIDTH  1600

unsigned char bitmap[MAXHEIGHT][MAXWIDTH][3];
unsigned char cell[16][16][3];
struct bmf_hdr  bmfHdr;
struct bmi_hdr  bmiHdr;
int width=0;
int height=0;
FILE *inFP;

void
outputBMP();
void getCell(FILE *file, unsigned long ccr);


int main(int argc, char **argv, char **envp)
{
    int x, y, px, py;
    char *inFile = 0;
    
    //
    // Process args
    //
    
    if (argc==2) {
	inFile = argv[1];
    } else {
	fprintf(stderr, "%s filename > image.bmp\n", argv[0]);
	exit(-1);
    }
 // Open it
    if (inFile) {
	if (!(inFP = (FILE *) fopen(inFile, "rb"))) {
	    fprintf(stderr, "ERROR: can't open file '%s'\n", inFile);
	    exit(-1);
	}
    }
    else
	inFP = stdin;
    
    
    
    /* parse width / height information from file header */
    fscanf(inFP, "%d %d %lx\n", &width, &height, &ccr);
    
    for(y=0; y<height; y=y+16) {
	for(x=0; x<width; x=x+16) {
	    /* tile pos */
	    getCell(inFP, ccr);
	    /* copy data from cell to bitmap */
	    for(py=0; py<16; py++) {
		for(px=0; px<16; px++) {
		    bitmap[y+py][x+px][RED]=cell[py][px][RED];
		    bitmap[y+py][x+px][GREEN]=cell[py][px][GREEN];
		    bitmap[y+py][x+px][BLUE]=cell[py][px][BLUE];
		}
	    }
	}
    }
    
    outputBMP();

    return 0;
}

void
outputBMP() {
    int imageSize, y;
    
// Write the file
    bcopy(&defBmfHdr, &bmfHdr, sizeof(struct bmf_hdr));
    bcopy(&defBmiHdr, &bmiHdr, sizeof(struct bmi_hdr));
    bmiHdr.biWidth[0] = width & 0xff;
    bmiHdr.biWidth[1] = (width >> 8) & 0xff;
    bmiHdr.biHeight[0] = height & 0xff;
    bmiHdr.biHeight[1] = (height >> 8) & 0xff;
    
    imageSize = height * width * 3;
    bmiHdr.biSizeImage[0] = imageSize & 0xFF;
    bmiHdr.biSizeImage[1] = (imageSize >> 8) & 0xFF;
    bmiHdr.biSizeImage[1] = (imageSize >> 16) & 0xFF;
    bmiHdr.biSizeImage[1] = (imageSize >> 24) & 0xFF;
    
    fwrite(&bmfHdr, BMFHDRSIZE, 1, stdout);
    fwrite(&bmiHdr, BMIHDRSIZE, 1, stdout);
    for (y = height-1; y >= 0; y--)
	fwrite(bitmap[y][0], 1, width*3, stdout);
}

static unsigned char *getPixel(FILE *file, unsigned char *pix)
{
    unsigned word;

    if(pix) {
	word=fgetc(file);
	word=word + 256*getc(file);
	pix[RED]=8*(0x1f & (word>>11));
	pix[GREEN]=4*(0x3f & (word>>5));
	pix[BLUE]=8*(0x1f & (word>>0));
    }
    return pix;
}

void getCell(FILE *file, unsigned long ccr)
{
    int x, y, j, k;
    unsigned char pix[3];

    switch(ccr & CCR_DOWN_MODE_MASK) {
    case DOWN_MODE_1X1:
	for(y=0; y<16; y++) {
	    for(x=0; x<16; x++) {
		getPixel(file, pix);
		cell[y][x][RED]=pix[RED];
		cell[y][x][GREEN]=pix[GREEN];
		cell[y][x][BLUE]=pix[BLUE];
	    }
	}
	break;
    case DOWN_MODE_2X2:
	for(y=0; y<8; y++) {
	    for(x=0; x<8; x++) {
		getPixel(file, pix);
		for(j=0; j<2; j++) {
		    for(k=0; k<2; k++) {
			cell[2*y+j][2*x+k][RED]=pix[RED];
			cell[2*y+j][2*x+k][GREEN]=pix[GREEN];
			cell[2*y+j][2*x+k][BLUE]=pix[BLUE];
		    }
		}
	    }
	}
	break;
    case DOWN_MODE_4X4:
	for(y=0; y<4; y++) {
	    for(x=0; x<4; x++) {
		getPixel(file, pix);
		for(j=0; j<4; j++) {
		    for(k=0; k<4; k++) {
			cell[4*y+j][4*x+k][RED]=pix[RED];
			cell[4*y+j][4*x+k][GREEN]=pix[GREEN];
			cell[4*y+j][4*x+k][BLUE]=pix[BLUE];
		    }
		}
	    }
	}
	break;
    case DOWN_MODE_8X8:
	for(y=0; y<2; y++) {
	    for(x=0; x<2; x++) {
		getPixel(file, pix);
		for(j=0; j<8; j++) {
		    for(k=0; k<8; k++) {
			cell[8*y+j][8*x+k][RED]=pix[RED];
			cell[8*y+j][8*x+k][GREEN]=pix[GREEN];
			cell[8*y+j][8*x+k][BLUE]=pix[BLUE];
		    }
		}
	    }
	}
	break;
    }
}


void usage() {
    fprintf(stderr, "usage: down2bmp [infile]\n"
	    "\tTakes image data on standard input, and generates BMP file to STDOUT.\n");

    exit(-1);
}
