#!/bin/sh

source ../Config.sh

arch=ppc
if [ "$PP_BUILD_ARCH" = "arm" ]; then
    arch=arm
fi

[ -x ${FW_TOPDIR}/bin/mkimage ] || {
    echo "u-boot must be built first!" >&2
    exit 1
}

gzip -cv9 < "$1" > "$1.gz"
${FW_TOPDIR}/bin/mkimage \
    -n "Ramdisk Image" -A $arch -O linux -T ramdisk -C gzip -d "$1.gz" "$2"
rm -f "$1.gz"
