#!/usr/bin/perl -w
###############################################################################
#
# fw-bin-to-prod.pl - converts a .bin FW file to K-Prod format or to a raw FW
#

package fw_bin_to_prod;

use strict;

#
###############################################################################
# imports
#

use FindBin;
use lib "$FindBin::Bin";
use lib "$FindBin::Bin/cpan";

use Getopt::Long;
use eRIC_Firmware;

#
###############################################################################
# global variables

my $usage =
  "FW .bin conversion tool - usage:\n\n" .
  "  fw-bin-to-prod.pl [-l <lightoem>] [-r <raw FW file>] <firmware binary>\n\n" .
  "    -r <raw FW file>  - create raw FW file in addition to dirs for K-Prod\n" .
  "    -l <lightoem>     - name the dirs below work/ according to <lightoem>\n" .
  "    <firmware binary> - the source firmware .bin file to convert\n\n";
my $parm_prefix   = "";
my $parm_lightoem = "";
my $parm_restore  = 0;
my $parm_help     = 0;
my $parm_raw_file = "";

#
###############################################################################
# main program
#

GetOptions("l:s" => \$parm_lightoem,
	   "r:s"   => \$parm_raw_file);

# -----------------------------------------------------------------------------
# check command line options
# -----------------------------------------------------------------------------

my $arg_cnt = $#ARGV+1;
($arg_cnt == 1) or die "\n$0: ERROR: exactly one <firmware binary> required!\n\n".$usage;

my $fw_file = shift @ARGV;
load_firmware($fw_file) or exit 1;

my $do_create_raw = 0;
if ($parm_raw_file) {
    $do_create_raw = 1;
}

# -----------------------------------------------------------------------------
# process the firmware file
# -----------------------------------------------------------------------------

fw_bin_to_production($parm_lightoem, $do_create_raw, $parm_raw_file) or exit 1;
print "\nDone.\n";

#
###############################################################################

