###############################################################################
#
#      replacepart_oem.pm
#        use to add/replace the oem flashdisk partition
#

package replacepart_oem;

use strict;

use vars qw(
            @ISA
            @EXPORT
           );
#
###############################################################################
# imports
#

use Getopt::Std;
use eRIC_Firmware;

#
###############################################################################
# prototypes
#
sub get_subpart_usage($$);

#
###############################################################################
# main program
#

sub replacepart_oem_main($$) {
    my $part_type = shift;
    my $part_subtype = shift;

    my $subparts = get_subpart_types($part_type);

    my $opts  = {};
    my $usage =
      "Usage: \n\n" .
      "  replacepart.pl [-d] [-a <part_file>] <firmware_file>\n\n" .
      "    -d                - delete part\n" .
      "    -a <part_file>    - add or replace part with <part_file>\n" .
      "    <firmware_file>   - the existing firmware file to change\n" .
      "  note: this file replaces 'replacepart.pl' of older web SDKs\n\n";

    getopts('da:', $opts);

    my $fw_file = shift @ARGV;  # first remaining element after getopts ...

    my $have_partfile = 0;

    defined($fw_file) or die "firmware file not specified\n\n$usage";

    my $delete_part = 0;
    if (defined($opts->{d})) {
        $delete_part = 1;
    }

    my $partfile;
    if (defined($opts->{a})) {
        my $pa = $opts->{a};
        if (-r $pa) {
    	    $partfile = $pa;
    	    $have_partfile = 1;
        } else {
    	    die "file \"$pa\" not readable.";
        }
    }

    # some constraints about multiple options
    if ($have_partfile && $delete_part) {
        die "replace a part and delete is not meaningful!";
    }

    ##################################
    # params gathered, execute 

    load_firmware($fw_file) or exit 1;
    print_fw_info_scarce($part_type) or exit 1;

    print "\n";
    if ($delete_part) { print "will delete partition : ", $part_type, ", ", $part_subtype, "\n"; }
    if ($have_partfile) { print "will replace subtype ", $part_type, ", ", $part_subtype, " with file ", $partfile, "\n"; }

    # save FW parts to disk
    my $parts = get_and_save_parts("replacepart_");

    if ($delete_part || $have_partfile) {
        # remove the part which should be deleted or replaced
        @{$parts} = grep(!($_->{"part_type"} == $part_type && $_->{"part_subtype"} == $part_subtype), @{$parts});
    }

    if ($have_partfile) {
        my $par;
        $par->{"file"} = $partfile;
        $par->{"part_type"} = $part_type;
        $par->{"part_subtype"} = $part_subtype;
        push @{$parts}, $par;
    }

    # reload partitions and recreate the firmware
    if ($delete_part || $have_partfile) {
        update_parts ( $parts, 3 ) or exit 1;
    
        print "\nResulting firmware file:\n";
    
        save_firmware($fw_file) or exit 1;
        load_firmware($fw_file) or exit 1;
        print_fw_info_scarce($part_type) or exit 1;
    }
}

###############################################################################
# subs

sub get_subpart_usage($$) {
  my $subparts = shift;
  my $indent = shift;
  my $ret;

  foreach my $subpart (keys %$subparts) {
    $ret .= ' ' x $indent . "$subpart " .
      (($subparts->{"$subpart"}->{"name"}) ? ("(" . $subparts->{"$subpart"}->{"name"} . ")") : "") . "\n";
  }

  return $ret;
}


#
###############################################################################
# exports
#

@ISA    = qw(Exporter);
@EXPORT = qw(
	     replacepart_oem_main
	    );

#
###############################################################################

