/***************************************************************************
 *   Copyright (C) 2004 by Ralf Guenther                                   *
 *   rgue@peppercon.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <unistd.h>

static void
usage(void)
{
	printf("Usage: poke [b|w|d] <phys mem addr> <val> [<len>]\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	int arg;
	char mode;
	unsigned long addr;
	unsigned long val;
	unsigned long len;
	size_t page_size;
	unsigned long offs;
	unsigned long base;
	unsigned long size;
	int fd;
	unsigned char *p;
	unsigned long i;

	if (argc < 3 || argc > 5) usage();
	
	arg = 1;
	 mode = 'b'; if (argv[arg][0] == 'b' || argv[arg][0] == 'w' || argv[arg][0] == 'd') mode = argv[arg++][0];
	if (sscanf(argv[arg++], "%li", &addr) != 1) usage();
	if (sscanf(argv[arg++], "%li", &val) != 1) usage();
	len = 1; if (arg < argc) if (sscanf(argv[arg++], "%li", &len) != 1) usage();
	
	switch (mode) {
	case 'b': printf("poking %ld byte(s) 0x%02x to 0x%08lx\n", len, (unsigned char)val, addr); break;
	case 'w': printf("poking %ld word(s) 0x%04x to 0x%08lx\n", len, (unsigned short)val, addr); break;
	case 'd': printf("poking %ld dword(s) 0x%08lx to 0x%08lx\n", len, val, addr); break;
	}
	
	page_size = (size_t)sysconf(_SC_PAGESIZE);
	offs = addr % page_size;
	base = addr - offs;
	size = len + offs;
	
	fd = open("/dev/mem",O_RDWR);
	if (fd == -1) { printf("Error: open /dev/mem failed: %s (%d)\n", strerror(errno), errno); exit(-1); }
	
	p = mmap(0, size, PROT_READ | PROT_WRITE, MAP_SHARED, fd, (off_t)base);
	if (p == (unsigned char*)-1) { printf("Error: mmap failed: %s (%d)\n", strerror(errno), errno); exit(-1); }
	
	for (i = 0; i < len; i++)
	{
		switch (mode) {
		case 'b': ((unsigned char*)&p[offs])[i] = val; break;
		case 'w': ((unsigned short*)&p[offs])[i] = val; break;
		case 'd': ((unsigned int*)&p[offs])[i] = val; break;
		}
	}
	
	if (-1 == munmap(p, size)) { printf("Error: munmap failed: %s (%d)\n", strerror(errno), errno); exit(-1); }
	if (-1 == close(fd)) { printf("Error: close /dev/mem failed: %s (%d)\n", strerror(errno), errno); exit(-1); }
	
	return 0;
}
