/*****************************************************************************
 *  Raritan Board Type Header File
 *
 *  FILE: board_type.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _BOARD_TYPE_H_
#define _BOARD_TYPE_H_

#define RARITAN_BOARD_GENERIC                         0x00000000
#define RARITAN_BOARD_KX101                           0x00000001
#define RARITAN_BOARD_KXGEN2                          0x00000002
#define RARITAN_BOARD_KSXGEN2                         0x00000003

/*
 * KX2.0 8-bit Hardware ID
 *  - Bits 0 and 1 are Vendor ID
 *
 *       Bit 0 1
 *      ---------------------
 *           0 0 = Peppercon
 *           0 1 = Raritan
 *
 *  - Bit 2 is product ID
 *
 *      0 = KX2.0
 *      1 = KSXG2
 *
 *  - Bits 3, 4, and 5 are model number
 *
 *       Model    Bits 3 4 5
 *      ---------------------
 *       KX432         0 0 0
 *       KX416         0 0 1
 *       KX232         0 1 0
 *       KX216         0 1 1
 *       KX132         1 0 0
 *       KX116         1 0 1
 *       KX464         1 1 0
 *
 *  - Bits 6 and 7 are PCB version number
 */
#define RARITAN_HWID_PCB_VERSION_MASK                 0x03
#define RARITAN_HWID_MODEL_MASK                       0x1C
#define RARITAN_HWID_PRODUCT_MASK                     0x20
#define RARITAN_HWID_VENDOR_MASK                      0xC0

#define RARITAN_HWID_PCB_VERSION_SHIFT                0

#define KX432_MODEL                                   0x00
#define KX416_MODEL                                   0x04
#define KX232_MODEL                                   0x08
#define KX216_MODEL                                   0x0C
#define KX132_MODEL                                   0x10
#define KX116_MODEL                                   0x14
#define KX464_MODEL                                   0x18

#define PEPPERCON_PRODUCT                             0x00
#define RARITAN_PRODUCT                               0x40

#endif /* _BOARD_TYPE_H_ */
