/*****************************************************************************
 *  Ethernet Test Menu
 *
 *  FILE: ether_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <command.h>
#include <net.h>
#include <ether_menu.h>
#include <util.h>


static void print_ether_menu( void )
{
    int i = 1;

    printf("\nEthernet Test:");
    print_exit();
    printf("\n\t %d: Select NetIF", i++);
    printf("\n\t %d: Select GigaBit Ethernet port", i++);
    printf("\n\t %d: Ping Test", i++);
    printf("\n\t %d: TFTP Test", i++);
    printf("\n\n");

    return;
}

int ether_menu( void )
{
    char ether_flag = 1;
    int result = 1; /* result is used for reverting back to U-boot cmds */
    int nchars;
    unsigned long diag_opt;
    int opt_res;
    cmd_tbl_t *cmdtp;
    char tmp[10];
    char *argv[2];
#if defined( CONFIG_NET_MULTI )
    ulong id;
    struct eth_device *eth_dev;
#endif

    while (ether_flag) {
        print_ether_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case ETHER_MENU_EXIT:
                ether_flag = 0;
                break;

            case ETHER_MENU_SELECT_NETIF:
#if defined( CONFIG_NET_MULTI )
                eth_dev = eth_get_dev();
                printf("\nCurrent LAN: %s", eth_dev->name);
                nchars = print_prompt("\nUse other device [0=No, 1=Yes]: ", &id, 10);
                if( nchars > 0 ) {
                    if (id == 1) {
                        /* switch ethernet device */
                        eth_try_another(0);
                        eth_dev = eth_get_dev();
                        printf("\nNew LAN: %s\n", eth_dev->name);
                    }
                }
#endif
                break;

            case ETHER_MENU_SELECT_GIGAETH:
                {
		    u32 gpio0_or;
		    gpio0_or = in32(GPIO0_OR);

		    printf("\nCurrent GigaBit LAN%d", (LAN_GPIO6&gpio0_or)?2:1);
		    nchars = print_prompt("\nUse other device [0=No, 1=Yes]: ", &id, 10);
		    if( nchars > 0 ) {
			if (id == 1) {
			    /* switch GigaBit ethernet port */
			    gpio0_or ^= LAN_GPIO6;
			    out32(GPIO0_OR, gpio0_or);
			    gpio0_or = in32(GPIO0_OR);
			    printf("\nNew GigaBit LAN%d\n", (LAN_GPIO6&gpio0_or)?2:1);
			}
		    }
                }
                break;

            case ETHER_MENU_PING_TEST:
                nchars = readline("\nEnter IP address to ping: ");
                if (nchars > 0) {
                    argv[0] = tmp;
                    strcpy(argv[0], "ping");
                    argv[1] = console_buffer;
                    if ((cmdtp = find_cmd(argv[0])) != NULL) {
                        (cmdtp->cmd) (cmdtp, 0, 2, argv);
                    }
                    else {
                        printf ("Unknown command 'ping'\n");
                    }
                }
                break;

            case ETHER_MENU_TFTP_TEST:
                /* passed parameter allowing user-input */
                eth_tftp_test(1);
                break;

            default:
                print_invalid();
                break;
        }
    }

    return result;
}

int eth_tftp_test( int user_input )
{
    cmd_tbl_t *cmdtp;
    char filename[64] = "u-boot.bin";
    char load_addr[12] = "0x100000";
    char tmp[] = "tftpboot";
    char *argv[3];
    int argc = 3;
    int num_chars;

    extern void tftp_disable_retry( void );
    extern void tftp_enable_retry( void );

    if (user_input) {
        num_chars = readline("\nEnter filename (default - u-boot.bin): ");
        if (num_chars > 0) {
            memset(filename, 0, 64);
            strncpy(filename, console_buffer, num_chars);
        }
        else if (num_chars < 0) {
            /* user change mind and hit Ctrl-C */
            printf("\n");
            return 0;
        }

        num_chars = readline("Enter load address (default - 0x100000): ");
        if (num_chars > 0) {
            memset(load_addr, 0, 12);
            strncpy(load_addr, console_buffer, num_chars);
        }
        else if (num_chars < 0) {
            /* user change mind and hit Ctrl-C */
            printf("\n");
            return 0;
        }
    }

    argv[0] = tmp;
    argv[1] = load_addr;
    argv[2] = filename;
    if ((cmdtp = find_cmd(argv[0])) == NULL) {
       return -1;
    }

    /* for this test, disable LAN switch-over */
    tftp_disable_retry();

    if ((cmdtp->cmd) (cmdtp, 0, argc, argv) != 0) {
       tftp_enable_retry();
       printf("ERROR: Failed to TFTP file.\n");
       return -2;
    }
    else {
       printf("Finished tftp %s to address %s of size 0x%lx\n",
              filename, load_addr, NetBootFileXferSize);
    }

    /* enable back LAN switch-over for tftp */
    tftp_enable_retry();

    return 0;
}
