/*****************************************************************************
 *  Bootloader, CONFIG, and JFFS2 Images Update Utilities Header
 *
 *  FILE: image_update.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _IMAGE_UPDATE_H_
#define _IMAGE_UPDATE_H_

extern int  boot_tftp_update( char *defname, int flash_bank, int sector_start, int sector_end );
extern int  config_tftp_update( int cfg_part );
extern int  jffs2_tftp_update( void );
extern int  tftp_update_whole_flash( char *defname, int flash_size, int sector_start, int sector_end );
extern void get_kernel_image_info( void );
extern void get_ramdisk_image_info( void );
extern void get_jffs2_image_info( void );

#endif /* _IMAGE_UPDATE_H_ */
