/*****************************************************************************
 *  LCD controller/Analog-to-Digital controller Driver for initializing,
 *  configuring, and testing the device
 *
 *  FILE: lcd.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <i2c.h>
#include <ad9888.h>
#include <lcd_raritan.h>

#ifdef CONFIG_KXGEN2
#include <pca9543a.h>
#endif

static u32 lcd_base_addr[CFG_MAX_LCD_DEVICES];
static u32 Lcd_cnt = 0;
static u32 known_addr[] = {
#ifdef CFG_I2C_LCD0_ADDR
    CFG_I2C_LCD0_ADDR,
#endif
#ifdef CFG_I2C_LCD1_ADDR
    CFG_I2C_LCD1_ADDR,
#endif
#ifdef CFG_I2C_LCD2_ADDR
    CFG_I2C_LCD2_ADDR,
#endif
#ifdef CFG_I2C_LCD3_ADDR
    CFG_I2C_LCD3_ADDR,
#endif
};


s32 lcd_hw_init( void )
{
#ifdef CONFIG_KXGEN2
    pca9543a_init();
#endif
    return LCD_SUCCESS;
}

u32 lcd_detect( void )
{
    int lcd;

    for(lcd = 0; lcd < CFG_MAX_LCD_DEVICES; lcd++) {
        lcd_base_addr[lcd] = known_addr[lcd];

#ifdef CONFIG_KXGEN2
        /*
         * The AD9888 chips only has 2 valid addresses.  KX2.0 have a maximum
         * of 4 AD9888 chips.  Thus, an i2c switch is required.
         */
        switch( lcd ) {
            case 0:
            case 1:
                pca9543a_select_channel(0);
                break;

            case 2:
            case 3:
                pca9543a_select_channel(1);
                break;

            default:
                break;
        }
#endif

        if(i2c_probe(lcd_base_addr[lcd]) == 0) {
            ++Lcd_cnt;
        }
        else if(lcd == 0) {
            /* this configuration is not possible, something is wrong */
            printf("ERROR: Unable to find 1st Video controller\n");
            return 0;
        }
    }

    return Lcd_cnt;
}

s32 lcd_sw_init( u32 lcd_cnt )
{
    int lcd;
    int err;

    if(ad9888_init(lcd_cnt) != LCD_SUCCESS) {
        return LCD_FAIL;
    }

    /* install each LCD */
    for(lcd = 0; lcd < lcd_cnt; lcd++) {
        err = ad9888_install(lcd, lcd_base_addr[lcd]);
        if(err != LCD_SUCCESS) {
            return err;
        }
    }

    /* test LCD access */
    for(lcd = 0; lcd < lcd_cnt; lcd++) {
        err = ad9888_test(lcd);
        if(err != LCD_SUCCESS) {
            /*
             * Uh oh! there's a problem with LCD/ADchip register accesses.
             * What do we do now?
             */
            return err;
        }
    }

    return LCD_SUCCESS;
}

u32 lcd_get_ndev( void )
{
    return Lcd_cnt;
}
