/******************************************************************************
 *  Intel LXT972A header file
 *
 *  FILE: lxt972.h
 *
 ******************************************************************************
 *
 *                        COPYRIGHT (c) 2003
 *
 *                       Raritan Computer, Inc.
 *                        400 Cottontail Lane
 *                        Somerset, NJ 08837
 *                           732.764.8886
 *
 *                      All rights reserved.
 * Copying, compilation, modification, distribution or any other use 
 *   whatsoever of this material is strictly prohibited except in
 * accordance with a Software License Agreement with Raritan Computers, Inc.
 *****************************************************************************/

#ifndef _LXT972_H_
#define _LXT972_H_

/* LXT972A Vendor Specific Registers */
#define LXT972_ANLPRNPR           8 /* Port Configuration Register */
#define LXT972_PCR               16 /* Port Configuration Register */
#define LXT972_SR2               17 /* Status Register 2 */
#define LXT972_IER               18 /* Interrupt Enable Register */
#define LXT972_ISR               19 /* Interrupt Status Register */
#define LXT972_LEDCR             20 /* LED Configuration Register */
#define LXT972_DCR               26 /* Digital Configuration Register */
#define LXT972_TCR               30 /* Transmit Control Register */

/* LXT972A Status Register 2 Definitions */
#define LXT972_SR2_SPEED         0x4000 /* 10/100 mode */
#define LXT972_SR2_TS            0x2000 /* Transmit status */
#define LXT972_SR2_RS            0x1000 /* Receive status */
#define LXT972_SR2_CS            0x0800 /* Collision status */
#define LXT972_SR2_LINK          0x0400 /* Link status */
#define LXT972_SR2_DM            0x0200 /* Duplex mode */
#define LXT972_SR2_AN            0x0100 /* Auto-Negotiation */
#define LXT972_SR2_ANC           0x0080 /* Auto-Negotiation Complete */
#define LXT972_SR2_POLAR         0x0020 /* Polarity status */
#define LXT972_SR2_PAUSE         0x0010 /* Pause status */
#define LXT972_SR2_ERROR         0x0008 /* Error status */

/* LED Id */
#define LXT972_LED1              0
#define LXT972_LED2              1
#define LXT972_LED3              2

/* LED display configuration */
#define LED_DISP_SPEED           0x0000
#define LED_DISP_TX              0x0001
#define LED_DISP_RX              0x0002
#define LED_DISP_COLLISION       0x0003
#define LED_DISP_LINK            0x0004
#define LED_DISP_DUPLEX          0x0005
#define LED_DISP_TX_RX           0x0007
#define LED_DISP_TEST_ON         0x0008
#define LED_DISP_TEST_OFF        0x0009
#define LED_DISP_TEST_BLINK_FAST 0x000A
#define LED_DISP_TEST_BLINK_SLOW 0x000B
#define LED_DISP_LINK_RX         0x000C
#define LED_DISP_LINK_ACTIVITY   0x000D
#define LED_DISP_DUPLEX_CLSN     0x000E

/* LED Frequency */
#define LED_STRETCH_30MS         0x0000
#define LED_STRETCH_60MS         0x0004
#define LED_STRETCH_100MS        0x0008

/* LED Pulse Stretch */
#define LED_STRETCH_DISABLE      0
#define LED_STRETCH_ENABLE       1

#endif /* _LXT972_H_ */
