/*****************************************************************************
 *  Memory Test and Utility header file
 *
 *  FILE: mem.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _MEM_H_
#define _MEM_H_

extern void mem_dump( unsigned long start, unsigned long length, char size );
extern void mem_fill( ulong addr, ulong length, char size, ulong writeval );
extern int  mem_test ( ulong s_addr, ulong e_addr, int continuous );
extern int  memtest_walking_ones( uint addr, uint size );
extern int  memtest_address( uint addr, uint size );
extern int  memtest_fill( uint addr, uint size, uint pattern );
extern int  memtest_modfill( uint addr, uint size );
extern void memtest_config_print( char enabled );

#endif /* _MEM_H_ */
