/*****************************************************************************
 *  Manufacturing Test header file
 *
 *  FILE: mfg_test.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _MFG_TEST_H_
#define _MFG_TEST_H_

typedef enum {
    MFGTST_LAN_NO_MAC_PORT                      = -46,
    MFGTST_RS485_LPBK_TX_TIMEDOUT               = -45,
    MFGTST_RS485_LPBK_RX_TIMEDOUT               = -44,
    MFGTST_RS485_FAIL_LPBK                      = -43,
    MFGTST_VIDEO_FAIL_GRAB                      = -42,
    MFGTST_FPGA_FAIL_LOGIC                      = -41,
    MFGTST_FPGA_FAIL_SDRAM                      = -40,
    MFGTST_FPGA_FAIL_REG_ACCESS                 = -39,
    MFGTST_LCD_FAIL_VIDEO_SYNC                  = -38,
    MFGTST_LCD_FAIL_REG_ACCESS                  = -37,
    MFGTST_LCD_NOT_FOUND                        = -36,
    MFGTST_LCD_NOT_EQUAL_FPGA                   = -35,
    MFGTST_RTC_FAIL_OPERATION                   = -34,
    MFGTST_RTC_BYPASS_SET_TIME                  = -33,
    MFGTST_RTC_FAIL_SET_TIME                    = -32,
    MFGTST_RTC_NOT_FOUND                        = -31,
    MFGTST_DTT_NOT_INIT                         = -30,
    MFGTST_DTT_NOT_FOUND                        = -29,
    MFGTST_LAN_FAIL_TFTP                        = -28,
    MFGTST_LAN_FAIL_PING                        = -27,
    MFGTST_LAN_NO_PINGCMD                       = -26,
    MFGTST_LAN_NO_SERVERIP                      = -25,
    MFGTST_LAN_NO_IPADDR                        = -24,
    MFGTST_LAN_NO_MAC_ADDR2                     = -23,
    MFGTST_LAN_NO_MAC_ADDR1                     = -22,
    MFGTST_FLASH_FAIL_JFFS2_RECOVERY            = -21,
    MFGTST_FLASH_FAIL_RAMDISK0_RECOVERY         = -20,
    MFGTST_FLASH_FAIL_KERNEL0_RECOVERY          = -19,
    MFGTST_FLASH_FAIL_CONFIG2_RECOVERY          = -18,
    MFGTST_FLASH_FAIL_CONFIG1_RECOVERY          = -17,
    MFGTST_FLASH_FAIL_ADDR                      = -16,
    MFGTST_FLASH_FAIL_FILL_PATTERN              = -15,
    MFGTST_FLASH_FAIL_WALK_ONES                 = -14,
    MFGTST_FLASH_FAIL_WRITE                     = -13,
    MFGTST_FLASH_FAIL_ERASE_VERIFY              = -12,
    MFGTST_FLASH_FAIL_ERASE                     = -11,
    MFGTST_FLASH_MIRROR_FAIL                    = -10,
    MFGTST_SDRAM_FAIL_ADDR_OFFSET_COMP_PATTERN  = -9,
    MFGTST_SDRAM_FAIL_ADDR_OFFSET_PATTERN       = -8,
    MFGTST_SDRAM_FAIL_BIT_FLIP_PATTERN          = -7,
    MFGTST_SDRAM_FAIL_AA_PATTERN                = -6,
    MFGTST_SDRAM_FAIL_55_PATTERN                = -5,
    MFGTST_SDRAM_FAIL_FF_PATTERN                = -4,
    MFGTST_SDRAM_FAIL_00_PATTERN                = -3,
    MFGTST_SDRAM_FAIL_ADDR_LINES                = -2,
    MFGTST_SDRAM_FAIL_DATA_LINES                = -1,
    MFGTST_PASS                                 =  0,
    MFGTST_HALTED                               =  1
} mfg_test_result_t;

typedef enum {
    MFG_TEST_FPGA_MENU_EXIT,
    MFG_TEST_FPGA_MENU_WHITE,
    MFG_TEST_FPGA_MENU_BLACK,
    MFG_TEST_FPGA_MENU_RED,
    MFG_TEST_FPGA_MENU_GREEN,
    MFG_TEST_FPGA_MENU_BLUE,
    MFG_TEST_FPGA_MENU_GET_DIFF,
    NUM_MFG_TEST_FPGA_MENU
} mfg_test_fpga_menu_t;

typedef enum {
    FLASH_TEST_MIRROR,
    FLASH_TEST_WALK_ONES,
    FLASH_TEST_FILL_PATTERN,
    FLASH_TEST_ADDR_A15_A31,
    FLASH_TEST_ADDR_A7_A14,
    FLASH_TEST_COMPLETE
} mfg_test_flashstage_t;

typedef enum {
    MEMORY_TEST_DATA,
    MEMORY_TEST_ADDR,
    MEMORY_TEST_00_PATTERN,
    MEMORY_TEST_FF_PATTERN,
    MEMORY_TEST_55_PATTERN,
    MEMORY_TEST_AA_PATTERN,
    MEMORY_TEST_BIT_FLIP_PATTERN,
    MEMORY_TEST_ADDR_OFFSET_PATTERN,
    MEMORY_TEST_ADDR_OFFSET_COMP_PATTERN,
    MEMORY_TEST_COMPLETE
} mfg_test_memstage_t;

extern int mfg_test( void );
extern int mfg_test_options( void );

#endif /* _MFG_TEST_H_ */
