/*****************************************************************************
 *  Intel LXT972A MII PHY Driver header file
 *
 *  FILE: mii_phy_10_100.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _MII_PHY_KX101_H_
#define _MII_PHY_KX101_H_


#define PHY_ID_LXT970                0x78100000 /* LXT970 */
#define PHY_ID_LXT972                0x001378e0 /* LXT971 and 972 */
#define PHY_ID_DM9161                0x0181B800 /* DM9161 */

/* LED Configuration Option */
#define PHY_LED_OPTION1              1
#define PHY_LED_OPTION2              2
#define PHY_LED_OPTION3              3

/* LED Id */
#define PHY_LED1                     0
#define PHY_LED2                     1
#define PHY_LED3                     2

/* PHY auto-negotiation flag */
#define AUTONEG_DISABLE              0
#define AUTONEG_ENABLE               1

extern int found_phy;

/* generic mii phy routines */
int  mii_check_phy(void);
int  mii_get_phy(void);
void mii_sw_reset(void);
void mii_read_all_regs(void);
void mii_get_status(void);
int  mii_phy_set_configuration(int auto_neg, int link_options);
int  mii_phy_get_configuration(int *auto_neg, int *link_options);
void mii_phy_print_configuration(int auto_neg, int link_options);
int  mii_phy_config_led(ushort led, ushort cfg, ushort option);

/* device specific routines */
void mii_phy_read_all_regs(void);
void mii_phy_get_status(void);
int  mii_phy_config_led_disp(ushort led, ushort disp);
int  mii_phy_config_led_freq(ushort pulse_stretch);
void mii_phy_config_led_ps(ushort ps);

#endif /* _MII_PHY_10_100_ */
