/*****************************************************************************
 *  Philips PCA9543A 2-channel I2C switch interface functions header file
 *
 *  FILE: pca9543a.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _PCA9543A_H_
#define _PCA9543A_H_

/*
 *  I2C Address
 * ----------------------------
 *  1 1 1 0 0 A1 A0 x
 *
 *  A0 = A1 = 0
 *  x  = 0 (Write)
 *  x  = 1 (Read)
 */
#define PCA9543A_I2C_ADDR        0x70  /* 0xE0 >> 1 */

extern void  pca9543a_init( void );
extern uchar pca9543a_read( void );
extern void  pca9543a_write( uchar val );
extern int   pca9543a_select_channel( char chan );

#endif /* _PCA9543A_H_ */
