/*****************************************************************************
 *  Philips PCF8574 Remote 8-bit I/O expander for I2C-bus interface functions
 *
 *  FILE: pcf8574.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _PCF8574_H_
#define _PCF8574_H_

/*
 *  I2C Address
 * ----------------------------
 *  0 1 0 0 A2 A1 A0 x
 *
 *  A0 = A1 = A2 = 0
 *  x  = 0 (Write)
 *  x  = 1 (Read)
 */
#define PCF8574_I2C_ADDR        0x20  /* 0x40 >> 1 */

extern uchar pcf8574_read( void );
extern void  pcf8574_write( uchar val );

#endif /* _PCF8574_H_ */
