/*****************************************************************************
 *  MII PHY DM9161 Utilities Menu
 *
 *  FILE: phy_dm9161_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_PHY)

#include <mii_phy_10_100.h>
#include <phy_dm9161_menu.h>
#include <dm9161.h>
#include <dm9161a.h>
#include <util.h>


static void print_ledcfg_menu( void )
{
    int i = 1;

    printf("\nMII PHY LED CONFIGURATION:");
    print_exit();
    printf("\n\t %d: Enable Speed LED", i++);
    printf("\n\t %d: Disable Speed LED", i++);
    printf("\n\t %d: Display Full/Half Duplex", i++);
    printf("\n\t %d: Display Full-Duplex/Collision", i++);
    printf("\n\n");

    return;
}

int phy_ledcfg_menu( int type )
{
    char phy_flag = 1;
    int result = 1;
    unsigned long diag_opt;
    int opt_res;
    ushort led = PHY_LED1;

    if( type != PHY_ID_DM9161 ) {
        return -1;
    }

    while (phy_flag) {
        print_ledcfg_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case PHY_DM9161_LEDCFG_EXIT:
                phy_flag = 0;
                break;

            case PHY_DM9161_LEDCFG_DISP_SPEED:
                mii_phy_config_led(led, LED_DISP_SPEED, PHY_LED_OPTION1);
                break;

            case PHY_DM9161_LEDCFG_DISP_OFF:
                mii_phy_config_led(led, LED_DISP_SPEED_OFF, PHY_LED_OPTION1);
                break;

            case PHY_DM9161_LEDCFG_DISP_DUPLEX:
                mii_phy_config_led(led, LED_DISP_DUPLEX, PHY_LED_OPTION1);
                break;

            case PHY_DM9161_LEDCFG_DISP_DUPLEX_CLSN:
                mii_phy_config_led(led, LED_DISP_DUPLEX_CLSN, PHY_LED_OPTION1);
                break;

            default:
                print_invalid();
                break;
       }
    }

    return result;
}

#endif /* (CFG_RARITAN_UTIL_PHY) */
