/*****************************************************************************
 *  MII PHY Menu header file
 *
 *  FILE: phy_menu.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _PHY_MENU_H_
#define _PHY_MENU_H_

/* MII PHY */
typedef enum {
    PHY_MENU_EXIT,
    PHY_MENU_SW_RESET,                /* 1 */
    PHY_MENU_READ_REG,
    PHY_MENU_WRITE_REG,
    PHY_MENU_READ_ALL_REG,
    PHY_MENU_GET_STATUS,              /* 5 */
    PHY_MENU_GET_CONFIG,
    PHY_MENU_CHANGE_CONFIG,
    PHY_MENU_CONFIG_LED,              /* 8 */
    NUM_PHY_MENU
} phy_menu_t;


/* MII PHY Configuration */
typedef enum {
    PHY_CFG_EXIT,
    PHY_CFG_AUTONEG_LINK_ALL,         /* 1 */
    PHY_CFG_AUTONEG_LINK_10_100HD,
    PHY_CFG_AUTONEG_LINK_100FD,
    PHY_CFG_AUTONEG_LINK_100HD,
    PHY_CFG_AUTONEG_LINK_10FD,        /* 5 */
    PHY_CFG_AUTONEG_LINK_10HD,
    PHY_CFG_LINK_100FD,
    PHY_CFG_LINK_100HD,
    PHY_CFG_LINK_10FD,
    PHY_CFG_LINK_10HD,                /* 10 */
    NUM_PHY_CFG,
} phy_cfg_menu_t;

/* MII PHY LXT970 LED Configuration */
typedef enum {
    PHY_LXT970_LEDCFG_EXIT,
    PHY_LXT970_LEDCFG_DISP_CLSN,
    PHY_LXT970_LEDCFG_DISP_OFF,
    PHY_LXT970_LEDCFG_DISP_ACT,
    PHY_LXT970_LEDCFG_DISP_ON,
    NUM_PHY_LXT970_LEDCFG
} phy_lxt970_ledcfg_menu_t;

extern int phy_menu( void );
extern int phy_ledcfg_menu( int type );

#endif /* _PHY_MENU_H_ */
